/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.arquillian.adapter;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.spi.context.ContainerContext;
import org.jboss.arquillian.container.spi.context.DeploymentContext;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;
import org.wildfly.swarm.arquillian.StartupTimeout;
import org.wildfly.swarm.arquillian.adapter.SimpleContainer;
import org.wildfly.swarm.arquillian.adapter.UberjarSimpleContainer;
import org.wildfly.swarm.arquillian.daemon.container.DaemonContainerConfigurationBase;
import org.wildfly.swarm.arquillian.daemon.container.DaemonDeployableContainerBase;

public class WildFlySwarmContainer
extends DaemonDeployableContainerBase<DaemonContainerConfigurationBase> {
    @Inject
    Instance<ContainerContext> containerContext;
    @Inject
    Instance<DeploymentContext> deploymentContext;
    private Set<String> requestedMavenArtifacts = new HashSet<String>();
    private SimpleContainer delegateContainer;
    private Class<?> testClass;

    public Class<DaemonContainerConfigurationBase> getConfigurationClass() {
        return DaemonContainerConfigurationBase.class;
    }

    public void start() throws LifecycleException {
    }

    public void setTestClass(Class<?> testClass) {
        this.testClass = testClass;
    }

    public void setRequestedMavenArtifacts(List<String> artifacts) {
        this.requestedMavenArtifacts = new HashSet<String>(artifacts);
    }

    public ProtocolMetaData deploy(Archive<?> archive) throws DeploymentException {
        StartupTimeout startupTimeout = this.testClass.getAnnotation(StartupTimeout.class);
        if (startupTimeout != null) {
            this.setTimeout(startupTimeout.value());
        }
        this.delegateContainer = new UberjarSimpleContainer((ContainerContext)this.containerContext.get(), this.testClass);
        try {
            this.delegateContainer.setJavaVmArguments(this.getJavaVmArguments()).requestedMavenArtifacts(this.requestedMavenArtifacts).start(archive);
            super.start();
            ProtocolMetaData metaData = new ProtocolMetaData();
            metaData.addContext((Object)this.createDeploymentContext(archive.getId()));
            return metaData;
        }
        catch (Exception e) {
            throw new DeploymentException(e.getMessage(), (Throwable)e);
        }
    }

    public void undeploy(Archive<?> archive) throws DeploymentException {
        try {
            this.delegateContainer.stop();
        }
        catch (Exception e) {
            throw new DeploymentException("Unable to stop process", (Throwable)e);
        }
    }

    public void deploy(Descriptor descriptor) throws DeploymentException {
    }

    public void undeploy(Descriptor descriptor) throws DeploymentException {
    }
}

