/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.arquillian.adapter;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.arquillian.container.spi.client.deployment.DeploymentDescription;
import org.jboss.arquillian.container.test.impl.client.deployment.AnnotationDeploymentScenarioGenerator;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.FileAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.impl.base.URLPackageScanner;
import org.jboss.shrinkwrap.impl.base.asset.AssetUtil;
import org.jboss.shrinkwrap.impl.base.path.BasicPath;
import org.wildfly.swarm.arquillian.DefaultDeployment;

public class DefaultDeploymentScenarioGenerator
extends AnnotationDeploymentScenarioGenerator {
    public List<DeploymentDescription> generate(TestClass testClass) {
        DefaultDeployment anno = (DefaultDeployment)testClass.getAnnotation(DefaultDeployment.class);
        if (anno == null) {
            return super.generate(testClass);
        }
        String classPrefix = anno.type() == DefaultDeployment.Type.JAR ? "" : "WEB-INF/classes";
        final Archive archive = anno.type() == DefaultDeployment.Type.JAR ? (Archive)ShrinkWrap.create(JavaArchive.class, (String)(testClass.getJavaClass().getSimpleName() + ".jar")) : (Archive)ShrinkWrap.create(WebArchive.class, (String)(testClass.getJavaClass().getSimpleName() + ".war"));
        ClassLoader cl = testClass.getJavaClass().getClassLoader();
        HashSet codeSources = new HashSet();
        URLPackageScanner.Callback callback = (className, asset) -> {
            ArchivePath classNamePath = AssetUtil.getFullPathForClassResource((String)className);
            BasicPath location = new BasicPath(classPrefix, classNamePath);
            archive.add(asset, (ArchivePath)location);
            try {
                Class<?> cls = cl.loadClass(className);
                codeSources.add(cls.getProtectionDomain().getCodeSource());
            }
            catch (ClassNotFoundException | NoClassDefFoundError throwable) {
                // empty catch block
            }
        };
        URLPackageScanner scanner = URLPackageScanner.newInstance((boolean)true, (ClassLoader)cl, (URLPackageScanner.Callback)callback, (String)testClass.getJavaClass().getPackage().getName());
        scanner.scanPackage();
        Set prefixes = codeSources.stream().map(e -> e.getLocation().toExternalForm()).collect(Collectors.toSet());
        try {
            ArrayList<URL> resources = Collections.list(cl.getResources(""));
            resources.stream().filter(e -> {
                for (String prefix : prefixes) {
                    if (!e.toExternalForm().startsWith(prefix)) continue;
                    return true;
                }
                return false;
            }).filter(e -> e.getProtocol().equals("file")).map(e -> this.getPlatformPath(e.getPath())).map(e -> Paths.get(e, new String[0])).filter(e -> Files.isDirectory(e, new LinkOption[0])).forEach(e -> {
                try {
                    Files.walkFileTree(e, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                            if (!file.toString().endsWith(".class")) {
                                Path location = e.relativize(file);
                                archive.add((Asset)new FileAsset(file.toFile()), DefaultDeploymentScenarioGenerator.this.javaSlashize(location));
                            }
                            return super.visitFile(file, attrs);
                        }
                    });
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
        DeploymentDescription description = new DeploymentDescription(testClass.getName(), archive);
        Class<?> mainClass = anno.main();
        if (mainClass != Void.class) {
            archive.add((Asset)new StringAsset(mainClass.getName()), "META-INF/arquillian-main-class");
        }
        description.shouldBeTestable(anno.testable());
        return Collections.singletonList(description);
    }

    protected String getPlatformPath(String path) {
        if (!this.isWindows()) {
            return path;
        }
        URI uri = URI.create("file://" + path);
        return Paths.get(uri).toString();
    }

    protected boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().contains("win");
    }

    public String javaSlashize(Path path) {
        ArrayList<String> parts = new ArrayList<String>();
        int numParts = path.getNameCount();
        for (int i = 0; i < numParts; ++i) {
            parts.add(path.getName(i).toString());
        }
        return String.join((CharSequence)"/", parts);
    }
}

