/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.arquillian.adapter;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.wildfly.swarm.arquillian.adapter.DependencyDeclarationFactory;
import org.wildfly.swarm.arquillian.adapter.GradleDependencyAdapter;
import org.wildfly.swarm.arquillian.resolver.ShrinkwrapArtifactResolvingHelper;
import org.wildfly.swarm.internal.FileSystemLayout;
import org.wildfly.swarm.tools.ArtifactSpec;
import org.wildfly.swarm.tools.DeclaredDependencies;

public class GradleDependencyDeclarationFactory
extends DependencyDeclarationFactory {
    private final FileSystemLayout fsLayout;

    public GradleDependencyDeclarationFactory(FileSystemLayout fsLayout) {
        this.fsLayout = fsLayout;
    }

    @Override
    public DeclaredDependencies create(ShrinkwrapArtifactResolvingHelper resolvingHelper) {
        DeclaredDependencies declaredDependencies = new DeclaredDependencies();
        GradleDependencyAdapter gradleAdapter = new GradleDependencyAdapter(this.fsLayout.getRootPath());
        List<String> coordinates = gradleAdapter.parseDependencies(GradleDependencyAdapter.Configuration.TEST_RUNTIME);
        List specs = coordinates.stream().map(c -> ArtifactSpec.fromMscGav((String)c)).collect(Collectors.toList());
        Set artifactSpecs = resolvingHelper.resolveAll(new HashSet(specs), false, false);
        for (ArtifactSpec artefact : artifactSpecs) {
            if (null == artefact.file) {
                throw new RuntimeException("Artifact file not resolved");
            }
            declaredDependencies.addExplicitDependency(artefact);
        }
        return declaredDependencies;
    }
}

