/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.arquillian.adapter;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Scanner;
import java.util.Stack;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.model.GradleProject;
import org.wildfly.swarm.tools.ArtifactSpec;
import org.wildfly.swarm.tools.DeclaredDependencies;

public class GradleDependencyAdapter {
    private static final String PREFIX1 = "+---";
    private static final String PREFIX2 = "\\---";
    private static final String PROJECT = "project";
    private static final String COLON = ":";
    private static final String PREFIX = "--- ";
    private static final String SUFFIX = " (*)";
    private static final String VERSION_UP = "-> ";
    private Stack<ArtifactSpec> stack = new Stack();
    private Path rootPath;

    public GradleDependencyAdapter(Path projectDir) {
        this.rootPath = projectDir;
    }

    public DeclaredDependencies parseDependencies(Configuration configuration) {
        System.out.println(this.rootPath);
        GradleConnector connector = GradleConnector.newConnector().forProjectDirectory(this.rootPath.toFile());
        ProjectConnection connection = connector.connect();
        GradleProject project = (GradleProject)connection.getModel(GradleProject.class);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ((BuildLauncher)((BuildLauncher)connection.newBuild().withArguments(new String[]{"dependencies", "--configuration", configuration.literal})).setStandardOutput((OutputStream)bout)).run();
        connection.close();
        DeclaredDependencies declaredDependencies = new DeclaredDependencies();
        String deps = new String(bout.toByteArray());
        Scanner scanner = new Scanner(deps);
        while (scanner.hasNextLine()) {
            String coord;
            String line = scanner.nextLine();
            if (line.startsWith(PREFIX1) || line.startsWith(PREFIX2)) {
                if (this.stack.size() > 0) {
                    this.stack.pop();
                }
                line = this.parseLine(line);
                coord = this.parseCoordinate(line);
                ArtifactSpec parent = DeclaredDependencies.createSpec((String)coord);
                declaredDependencies.add((Object)parent);
                this.stack.push(parent);
                continue;
            }
            if (!line.contains(PREFIX) || (line = this.parseLine(line)).startsWith(PROJECT)) continue;
            coord = this.parseCoordinate(line);
            declaredDependencies.add((Object)this.stack.peek(), (Object)DeclaredDependencies.createSpec((String)coord));
        }
        scanner.close();
        return declaredDependencies;
    }

    private String parseCoordinate(String line) {
        String[] coords = line.split(COLON);
        if (3 == coords.length) {
            String version = coords[2];
            if (version.contains(VERSION_UP)) {
                String s = coords[0] + COLON + coords[1] + COLON + version.substring(version.indexOf(VERSION_UP) + VERSION_UP.length(), version.length());
                return s;
            }
            return line;
        }
        throw new IllegalArgumentException("Unexpected input format");
    }

    private String parseLine(String line) {
        if ((line = line.substring(line.indexOf(PREFIX) + PREFIX.length(), line.length())).endsWith(SUFFIX)) {
            line = line.substring(0, line.indexOf(SUFFIX));
        }
        return line;
    }

    public static enum Configuration {
        ARCHIVE("archives"),
        DEFAULT("default"),
        COMPILE("compile"),
        RUNTIME("runtime"),
        TEST_COMPILE("testCompile"),
        TEST_RUNTIME("testRuntime");

        private String literal;

        private Configuration(String literal) {
            this.literal = literal;
        }
    }
}

