/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.arquillian.adapter;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.shrinkwrap.resolver.api.maven.ConfigurableMavenResolverSystem;
import org.jboss.shrinkwrap.resolver.api.maven.PomEquippedResolveStage;

public final class MavenProfileLoader {
    private static final Pattern profilePattern = Pattern.compile("-P([\\w\\-,]+)");
    private static String[] profiles = new String[0];
    private static boolean profilesDiscovered = false;

    private MavenProfileLoader() {
    }

    public static PomEquippedResolveStage loadPom(ConfigurableMavenResolverSystem resolver) {
        return (PomEquippedResolveStage)resolver.loadPomFromFile("pom.xml", MavenProfileLoader.determineProfiles());
    }

    public static String[] determineProfiles() {
        String mavenArgs;
        if (!profilesDiscovered && (mavenArgs = System.getProperty("env.MAVEN_CMD_LINE_ARGS")) != null) {
            Matcher matcher = profilePattern.matcher(mavenArgs);
            if (matcher.find()) {
                String activatedProfiles = matcher.group(1);
                profiles = activatedProfiles.split(",");
            }
            profilesDiscovered = true;
        }
        return profiles;
    }
}

