/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.arquillian.adapter;

import java.util.Optional;
import org.jboss.shrinkwrap.resolver.api.maven.ConfigurableMavenResolverSystem;
import org.jboss.shrinkwrap.resolver.api.maven.PomEquippedResolveStage;
import org.wildfly.swarm.internal.FileSystemLayout;
import org.wildfly.swarm.internal.MavenArgsParser;

public final class MavenProfileLoader {
    public static final String ENV_MAVEN_CMD_LINE_ARGS = "env.MAVEN_CMD_LINE_ARGS";
    private static String[] profiles = new String[0];
    private static boolean profilesDiscovered = false;

    private MavenProfileLoader() {
    }

    public static PomEquippedResolveStage loadPom(ConfigurableMavenResolverSystem resolver) {
        return (PomEquippedResolveStage)resolver.loadPomFromFile(FileSystemLayout.resolveMavenBuildFileName(), MavenProfileLoader.determineProfiles());
    }

    public static String[] determineProfiles() {
        String commandLine;
        if (!profilesDiscovered && (commandLine = System.getProperty(ENV_MAVEN_CMD_LINE_ARGS)) != null) {
            MavenArgsParser args = MavenArgsParser.parse((String)commandLine);
            Optional p_arg = args.get(MavenArgsParser.ARG.P);
            if (p_arg.isPresent()) {
                profiles = ((String)p_arg.get()).split(",");
            }
            profilesDiscovered = true;
        }
        return profiles;
    }
}

