/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.arquillian;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.List;

public final class ReflectionUtil {
    private ReflectionUtil() {
        throw new UnsupportedOperationException("No instantiation");
    }

    public static List<Method> getMethodsWithAnnotation(Class<?> source, Class<? extends Annotation> annotationClass) {
        List declaredAccessableMethods = AccessController.doPrivileged(() -> {
            ArrayList<Method> foundMethods = new ArrayList<Method>();
            for (Method method : source.getMethods()) {
                if (!method.isAnnotationPresent(annotationClass)) continue;
                if (!method.isAccessible()) {
                    method.setAccessible(true);
                }
                foundMethods.add(method);
            }
            return foundMethods;
        });
        return declaredAccessableMethods;
    }
}

