/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.arquillian.adapter;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.context.ContainerContext;
import org.jboss.arquillian.container.spi.context.DeploymentContext;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.container.ClassContainer;
import org.jboss.shrinkwrap.api.container.LibraryContainer;
import org.jboss.shrinkwrap.api.container.ManifestContainer;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenCoordinate;
import org.wildfly.swarm.Swarm;
import org.wildfly.swarm.arquillian.CreateSwarm;
import org.wildfly.swarm.arquillian.adapter.AnnotationBasedMain;
import org.wildfly.swarm.arquillian.adapter.DependencyDeclarationFactory;
import org.wildfly.swarm.arquillian.adapter.MainSpecifier;
import org.wildfly.swarm.arquillian.adapter.SimpleContainer;
import org.wildfly.swarm.arquillian.adapter.resources.ContextRoot;
import org.wildfly.swarm.arquillian.resolver.ShrinkwrapArtifactResolvingHelper;
import org.wildfly.swarm.bootstrap.util.BootstrapProperties;
import org.wildfly.swarm.bootstrap.util.TempFileManager;
import org.wildfly.swarm.internal.FileSystemLayout;
import org.wildfly.swarm.spi.api.DependenciesContainer;
import org.wildfly.swarm.spi.api.JARArchive;
import org.wildfly.swarm.spi.api.MarkerContainer;
import org.wildfly.swarm.tools.ArtifactResolvingHelper;
import org.wildfly.swarm.tools.ArtifactSpec;
import org.wildfly.swarm.tools.BuildTool;
import org.wildfly.swarm.tools.DeclaredDependencies;
import org.wildfly.swarm.tools.exec.SwarmExecutor;
import org.wildfly.swarm.tools.exec.SwarmProcess;

public class UberjarSimpleContainer
implements SimpleContainer {
    private final ContainerContext containerContext;
    private final DeploymentContext deploymentContext;
    private final Class<?> testClass;
    private SwarmProcess process;
    private Set<String> requestedMavenArtifacts = new HashSet<String>();
    private String javaVmArguments;
    private File workingDirectory;

    public UberjarSimpleContainer(ContainerContext containerContext, DeploymentContext deploymentContext, Class<?> testClass) {
        this.containerContext = containerContext;
        this.deploymentContext = deploymentContext;
        this.testClass = testClass;
    }

    @Override
    public UberjarSimpleContainer requestedMavenArtifacts(Set<String> artifacts) {
        this.requestedMavenArtifacts = artifacts;
        return this;
    }

    @Override
    public UberjarSimpleContainer setJavaVmArguments(String javaVmArguments) {
        this.javaVmArguments = javaVmArguments;
        return this;
    }

    @Override
    public void start(Archive<?> archive) throws Exception {
        WebArchive webArchive;
        archive.add((Asset)EmptyAsset.INSTANCE, "META-INF/arquillian-testable");
        ContextRoot contextRoot = null;
        if (archive.getName().endsWith(".war")) {
            contextRoot = new ContextRoot("/");
            Node jbossWebNode = ((WebArchive)archive.as(WebArchive.class)).get("WEB-INF/jboss-web.xml");
            if (jbossWebNode != null && jbossWebNode.getAsset() != null) {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(jbossWebNode.getAsset().openStream()));){
                    String content = String.join((CharSequence)"\n", reader.lines().collect(Collectors.toList()));
                    Pattern pattern = Pattern.compile("<context-root>(.+)</context-root>");
                    Matcher matcher = pattern.matcher(content);
                    if (matcher.find()) {
                        contextRoot = new ContextRoot(matcher.group(1));
                    }
                }
            }
            this.deploymentContext.getObjectStore().add(ContextRoot.class, (Object)contextRoot);
        }
        MainSpecifier mainSpecifier = (MainSpecifier)this.containerContext.getObjectStore().get(MainSpecifier.class);
        boolean annotatedCreateSwarm = false;
        Method swarmMethod = this.getAnnotatedMethodWithAnnotation(this.testClass, CreateSwarm.class);
        List<Class<?>> types = this.determineTypes(this.testClass);
        if (swarmMethod != null) {
            if (Modifier.isStatic(swarmMethod.getModifiers())) {
                annotatedCreateSwarm = true;
                types.add(CreateSwarm.class);
                types.add(AnnotationBasedMain.class);
                ((JARArchive)archive.as(JARArchive.class)).addModule("org.wildfly.swarm.container");
                ((JARArchive)archive.as(JARArchive.class)).addModule("org.wildfly.swarm.configuration");
            } else {
                throw new IllegalArgumentException(String.format("Method annotated with %s is %s but it is not static", CreateSwarm.class.getSimpleName(), swarmMethod));
            }
        }
        if (types.size() > 0) {
            try {
                ((ClassContainer)archive).addClasses(types.toArray(new Class[types.size()]));
            }
            catch (UnsupportedOperationException e) {
                ((JARArchive)archive.as(JARArchive.class)).addClasses(types.toArray(new Class[types.size()]));
            }
        }
        ShrinkwrapArtifactResolvingHelper resolvingHelper = ShrinkwrapArtifactResolvingHelper.defaultInstance();
        BuildTool tool = new BuildTool((ArtifactResolvingHelper)resolvingHelper).fractionDetectionMode(BuildTool.FractionDetectionMode.when_missing).bundleDependencies(false);
        String additionalModules = System.getProperty("swarm.build.modules");
        if (null == additionalModules) {
            File modulesDir = new File("target/classes/modules");
            String string = additionalModules = modulesDir.exists() ? modulesDir.getAbsolutePath() : null;
        }
        if (additionalModules != null) {
            tool.additionalModules((Collection)Stream.of(additionalModules.split(":")).map(File::new).filter(File::exists).map(File::getAbsolutePath).collect(Collectors.toList()));
        }
        SwarmExecutor executor = new SwarmExecutor().withDefaultSystemProperties();
        if (annotatedCreateSwarm) {
            executor.withProperty("swarm.arquillian.createswarm.class", this.testClass.getName());
        }
        if (contextRoot != null) {
            executor.withProperty("swarm.context.path", contextRoot.context());
        }
        executor.withProperty("swarm.inhibit.auto-stop", "true");
        String additionalRepos = System.getProperty("swarm.build.repos");
        additionalRepos = additionalRepos != null ? additionalRepos + "," : "";
        additionalRepos = additionalRepos + "https://repository.jboss.org/nexus/content/groups/public/";
        executor.withProperty("remote.maven.repo", additionalRepos);
        FileSystemLayout fsLayout = FileSystemLayout.create();
        DeclaredDependencies declaredDependencies = DependencyDeclarationFactory.newInstance(fsLayout).create(fsLayout, resolvingHelper);
        tool.declaredDependencies(declaredDependencies);
        if (archive instanceof DependenciesContainer) {
            DependenciesContainer depContainer = (DependenciesContainer)archive;
            if (depContainer.hasMarker("org.wildfly.swarm.allDependencies")) {
                this.munge(depContainer, declaredDependencies);
            }
        } else if (archive instanceof WebArchive && MarkerContainer.hasMarker((Archive)(webArchive = (WebArchive)archive), (String)"org.wildfly.swarm.allDependencies")) {
            this.munge(webArchive, declaredDependencies);
        }
        tool.projectArchive(archive);
        String debug = System.getProperty("swarm.debug.port");
        if (debug != null) {
            try {
                executor.withDebug(Integer.valueOf(Integer.parseInt(debug)));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(String.format("Failed to parse %s of \"%s\"", "swarm.debug.port", debug), e);
            }
        }
        if (mainSpecifier != null) {
            String[] args;
            tool.mainClass(mainSpecifier.getClassName());
            for (String arg : args = mainSpecifier.getArgs()) {
                executor.withArgument(arg);
            }
        } else if (annotatedCreateSwarm) {
            tool.mainClass(AnnotationBasedMain.class.getName());
        } else {
            Optional<String> mainClassName = Optional.empty();
            Node node = archive.get("META-INF/arquillian-main-class");
            if (node != null && node.getAsset() != null) {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(node.getAsset().openStream()));){
                    mainClassName = reader.lines().findFirst();
                }
            }
            tool.mainClass(mainClassName.orElse(Swarm.class.getName()));
        }
        if (this.testClass != null) {
            tool.testClass(this.testClass.getName());
        }
        Archive wrapped = null;
        try {
            wrapped = tool.build();
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw t;
        }
        if (BootstrapProperties.flagIsSet((String)"swarm.export.uberjar")) {
            File out = new File(wrapped.getName());
            System.err.println("Exporting swarm jar to " + out.getAbsolutePath());
            ((ZipExporter)wrapped.as(ZipExporter.class)).exportTo(out, true);
        }
        File executable = File.createTempFile("wfswarmarquillian", "-swarm.jar");
        ((ZipExporter)wrapped.as(ZipExporter.class)).exportTo(executable, true);
        executable.deleteOnExit();
        String mavenRepoLocal = System.getProperty("maven.repo.local");
        if (mavenRepoLocal != null) {
            executor.withProperty("maven.repo.local", mavenRepoLocal);
        }
        executor.withProperty("java.net.preferIPv4Stack", "true");
        File processFile = File.createTempFile("wfswarmmainprocessfile", null);
        executor.withProcessFile(processFile);
        executor.withJVMArguments(this.getJavaVmArgumentsList());
        executor.withExecutableJar(executable.toPath());
        this.workingDirectory = TempFileManager.INSTANCE.newTempDirectory("arquillian", null);
        executor.withWorkingDirectory(this.workingDirectory.toPath());
        this.process = executor.execute();
        this.process.getOutputStream().close();
        this.process.awaitReadiness(2L, TimeUnit.MINUTES);
        if (!this.process.isAlive()) {
            throw new DeploymentException("Process failed to start");
        }
        if (this.process.getError() != null) {
            throw new DeploymentException("Error starting process", (Throwable)this.process.getError());
        }
    }

    private <C extends LibraryContainer<?> & ManifestContainer<?>> void munge(C container, DeclaredDependencies declaredDependencies) {
        for (ArtifactSpec artifact : declaredDependencies.getRuntimeExplicitAndTransientDependencies()) {
            assert (artifact.file != null) : "artifact.file cannot be null at this point: " + artifact;
            container.addAsLibrary(artifact.file);
        }
        try {
            MarkerContainer.addMarker((ManifestContainer<?>)container, (String)"org.wildfly.swarm.allDependencies.added");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private List<Class<?>> determineTypes(Class<?> testClass) {
        ArrayList types = new ArrayList();
        for (Class<?> clazz = testClass; clazz != null && clazz != Object.class; clazz = clazz.getSuperclass()) {
            types.add(clazz);
            List<Class<?>> interfaces = Arrays.asList(clazz.getInterfaces());
            types.addAll(interfaces);
            for (Class<?> iface : interfaces) {
                List<Class<?>> superInterfaces = Arrays.asList(iface.getInterfaces());
                types.addAll(superInterfaces);
            }
        }
        return types;
    }

    private void registerContainerFactory(Archive<?> archive, Class<?> clazz) {
        ((JavaArchive)((JavaArchive)archive.as(JavaArchive.class)).addAsServiceProvider("org.wildfly.swarm.ContainerFactory", new String[]{clazz.getName()})).addClass(clazz);
        ((JARArchive)archive.as(JARArchive.class)).addModule("org.wildfly.swarm.container");
        ((JARArchive)archive.as(JARArchive.class)).addModule("org.wildfly.swarm.configuration");
    }

    @Override
    public void stop() throws Exception {
        this.process.stop();
        TempFileManager.deleteRecursively((File)this.workingDirectory);
    }

    private String ga(MavenCoordinate coord) {
        return String.format("%s:%s", coord.getGroupId(), coord.getArtifactId());
    }

    private String gav(MavenCoordinate coord) {
        return this.gav(coord.getGroupId(), coord.getArtifactId(), coord.getVersion());
    }

    private String gav(String group, String artifact, String version) {
        return String.format("%s:%s:%s", group, artifact, version);
    }

    private List<String> getJavaVmArgumentsList() {
        if (this.javaVmArguments == null) {
            return Collections.emptyList();
        }
        ArrayList<String> args = new ArrayList<String>();
        StringTokenizer tokens = new StringTokenizer(this.javaVmArguments);
        while (tokens.hasMoreTokens()) {
            args.add(tokens.nextToken());
        }
        return args;
    }

    private void deleteRecursively(File file) {
        File[] files;
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (File child : files) {
                this.deleteRecursively(child);
            }
        }
        file.delete();
    }
}

