/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.arquillian.daemon;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class TestRunner {
    private static final String CLASS_NAME_ARQ_TEST_RUNNERS = "org.jboss.arquillian.container.test.spi.util.TestRunners";
    private static final String METHOD_NAME_GET_TEST_RUNNER = "getTestRunner";
    private static final String METHOD_NAME_EXECUTE = "execute";
    final ClassLoader deploymentLoader;

    public TestRunner(ClassLoader loader) {
        this.deploymentLoader = loader;
    }

    public Serializable executeTest(String testClassName, String methodName) throws IllegalStateException {
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> testRunnersClass;
            Class<?> testClass;
            Thread.currentThread().setContextClassLoader(this.deploymentLoader);
            try {
                testClass = this.deploymentLoader.loadClass(testClassName);
            }
            catch (ClassNotFoundException cnfe) {
                throw new IllegalStateException("Could not load class " + testClassName);
            }
            try {
                testRunnersClass = this.deploymentLoader.loadClass(CLASS_NAME_ARQ_TEST_RUNNERS);
            }
            catch (ClassNotFoundException cnfe) {
                throw new IllegalStateException("Could not load class org.jboss.arquillian.container.test.spi.util.TestRunners");
            }
            Method getTestRunnerMethod = testRunnersClass.getMethod(METHOD_NAME_GET_TEST_RUNNER, ClassLoader.class);
            Object testRunner = getTestRunnerMethod.invoke(null, this.deploymentLoader);
            Class<?> testRunnerClass = testRunner.getClass();
            Method executeMethod = testRunnerClass.getMethod(METHOD_NAME_EXECUTE, Class.class, String.class);
            Serializable serializable = (Serializable)executeMethod.invoke(testRunner, testClass, methodName);
            return serializable;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException iae) {
            throw new RuntimeException(iae);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCL);
        }
    }
}

