/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.arquillian.daemon;

import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceActivator;
import org.jboss.msc.service.ServiceActivatorContext;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistryException;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.swarm.arquillian.daemon.server.Server;
import org.wildfly.swarm.arquillian.daemon.server.ServerLifecycleException;

public class DaemonServiceActivator
implements ServiceActivator {
    public void activate(ServiceActivatorContext serviceActivatorContext) throws ServiceRegistryException {
        DaemonService runner = new DaemonService();
        serviceActivatorContext.getServiceTarget().addService(ServiceName.of((String[])new String[]{"wildfly", "swarm", "arquillian", "daemon", "runner"}), (Service)runner).addDependency(ServiceName.JBOSS.append(new String[]{"as", "service-module-loader"}), ModuleLoader.class, runner.getServiceLoader()).setInitialMode(ServiceController.Mode.ACTIVE).install();
    }

    class DaemonService
    implements Service<Void> {
        private Server server;
        private InjectedValue<ModuleLoader> serviceLoader = new InjectedValue();

        DaemonService() {
        }

        public void start(StartContext context) throws StartException {
            try {
                String moduleName;
                String artifactName = System.getProperty("swarm.app.artifact");
                if (artifactName == null) {
                    throw new StartException("Failed to find artifact name under swarm.app.artifact");
                }
                ModuleLoader serviceLoader = (ModuleLoader)this.serviceLoader.getValue();
                Module module = serviceLoader.loadModule(ModuleIdentifier.create((String)(moduleName = "deployment." + artifactName)));
                if (module == null) {
                    throw new StartException("Failed to find deployment module under " + moduleName);
                }
                this.server = Server.create("localhost", 12345, (ClassLoader)module.getClassLoader());
                this.server.start();
            }
            catch (ModuleLoadException | ServerLifecycleException e) {
                throw new StartException(e);
            }
        }

        public void stop(StopContext context) {
            try {
                this.server.stop();
            }
            catch (ServerLifecycleException e) {
                throw new RuntimeException(e);
            }
        }

        public Void getValue() throws IllegalStateException, IllegalArgumentException {
            return null;
        }

        public Injector<ModuleLoader> getServiceLoader() {
            return this.serviceLoader;
        }
    }
}

