/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.arquillian.daemon;

import java.net.BindException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.server.deployment.Services;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceActivator;
import org.jboss.msc.service.ServiceActivatorContext;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistryException;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.swarm.arquillian.daemon.server.Server;
import org.wildfly.swarm.arquillian.daemon.server.ServerLifecycleException;

public class DaemonServiceActivator
implements ServiceActivator {
    public void activate(ServiceActivatorContext serviceActivatorContext) throws ServiceRegistryException {
        DaemonService.addService(serviceActivatorContext.getServiceTarget());
    }

    static class DaemonService
    implements Service<Void> {
        private static final Logger log = Logger.getLogger(DaemonService.class.getName());
        private final InjectedValue<DeploymentUnit> injectedDeploymentUnit = new InjectedValue();
        private Server server;

        DaemonService() {
        }

        public void start(StartContext context) throws StartException {
            int port = Integer.getInteger("swarm.arquillian.daemon.port", 12345);
            try {
                DeploymentUnit depunit = (DeploymentUnit)this.injectedDeploymentUnit.getValue();
                this.server = Server.create("localhost", port, depunit);
                this.server.start();
            }
            catch (Exception e) {
                if (e instanceof BindException) {
                    log.log(Level.SEVERE, "Couldn't bind Arquillian Daemon on localhost:" + port + "; you can change the port using system property '" + "swarm.arquillian.daemon.port" + "'", e);
                }
                throw new StartException((Throwable)e);
            }
        }

        public void stop(StopContext context) {
            try {
                this.server.stop();
            }
            catch (ServerLifecycleException e) {
                throw new RuntimeException(e);
            }
        }

        public Void getValue() throws IllegalStateException, IllegalArgumentException {
            return null;
        }

        static void addService(ServiceTarget serviceTarget) {
            String artifactName = System.getProperty("swarm.app.artifact");
            if (artifactName == null) {
                throw new IllegalStateException("Failed to find artifact name under swarm.app.artifact");
            }
            DaemonService runner = new DaemonService();
            serviceTarget.addService(ServiceName.of((String[])new String[]{"wildfly", "swarm", "arquillian", "daemon", "runner"}), (Service)runner).addDependency(Services.deploymentUnitName((String)artifactName), DeploymentUnit.class, runner.injectedDeploymentUnit).addDependency(Services.deploymentUnitName((String)artifactName, (Phase)Phase.POST_MODULE)).setInitialMode(ServiceController.Mode.ACTIVE).install();
        }
    }
}

