/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.arquillian.daemon.container;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;
import org.wildfly.swarm.arquillian.daemon.container.DaemonContainerConfigurationBase;
import org.wildfly.swarm.arquillian.daemon.protocol.DaemonProtocol;
import org.wildfly.swarm.arquillian.daemon.protocol.DeploymentContext;
import org.wildfly.swarm.arquillian.daemon.protocol.WireProtocol;

public abstract class DaemonDeployableContainerBase<CONFIGTYPE extends DaemonContainerConfigurationBase>
implements DeployableContainer<CONFIGTYPE> {
    private static final Logger log = Logger.getLogger(DaemonDeployableContainerBase.class.getName());
    private static final String ERROR_MESSAGE_DESCRIPTORS_UNSUPPORTED = "Descriptor deployment not supported";
    private InetSocketAddress remoteAddress;
    private Socket socket;
    private OutputStream socketOutstream;
    private InputStream socketInstream;
    private BufferedReader reader;
    private PrintWriter writer;
    private int timeout = 10;
    private String javaVmArguments;

    public void setup(CONFIGTYPE configuration) {
        InetSocketAddress address;
        String remoteHost = ((DaemonContainerConfigurationBase)configuration).getHost();
        String remotePort = ((DaemonContainerConfigurationBase)configuration).getPort();
        this.remoteAddress = address = new InetSocketAddress(remoteHost, Integer.parseInt(remotePort));
        this.javaVmArguments = ((DaemonContainerConfigurationBase)configuration).getJavaVmArguments();
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void start() throws LifecycleException {
        try {
            BufferedReader reader;
            InputStream socketInstream;
            PrintWriter writer;
            OutputStream socketOutstream;
            long startTime = System.currentTimeMillis();
            int secondsToWait = this.timeout;
            long acceptableTime = startTime + (long)(1000 * secondsToWait);
            Socket socket = null;
            while (true) {
                try {
                    socket = new Socket(this.remoteAddress.getHostString(), this.remoteAddress.getPort());
                    if (!log.isLoggable(Level.FINEST)) break;
                    log.finest("Got connection to " + this.remoteAddress.toString());
                    break;
                }
                catch (ConnectException ce) {
                    long currentTime;
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("No connection yet available to remote process");
                    }
                    if ((currentTime = System.currentTimeMillis()) > acceptableTime) {
                        throw new LifecycleException("Could not connect to the server at " + this.remoteAddress.getHostString() + ":" + this.remoteAddress.getPort() + " in the allotted " + secondsToWait + "s", (Throwable)ce);
                    }
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException e) {
                        Thread.interrupted();
                        throw new RuntimeException("No one should be interrupting us while we're waiting to connect", e);
                    }
                }
            }
            assert (socket != null) : "Socket should have been connected";
            this.socket = socket;
            this.socketOutstream = socketOutstream = socket.getOutputStream();
            this.writer = writer = new PrintWriter((Writer)new OutputStreamWriter(socketOutstream, WireProtocol.CHARSET), true);
            this.socketInstream = socketInstream = socket.getInputStream();
            this.reader = reader = new BufferedReader(new InputStreamReader(socketInstream));
        }
        catch (IOException ioe) {
            this.closeRemoteResources();
            throw new LifecycleException("Could not open connection to remote process", (Throwable)ioe);
        }
    }

    public void stop() throws LifecycleException {
        this.closeRemoteResources();
    }

    public ProtocolDescription getDefaultProtocol() {
        return DaemonProtocol.DESCRIPTION;
    }

    public void deploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException(ERROR_MESSAGE_DESCRIPTORS_UNSUPPORTED);
    }

    public void undeploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException(ERROR_MESSAGE_DESCRIPTORS_UNSUPPORTED);
    }

    protected DeploymentContext createDeploymentContext(String deploymentId) {
        return DeploymentContext.create(deploymentId, this.socketInstream, this.socketOutstream, this.reader, this.writer);
    }

    protected final InetSocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    protected final PrintWriter getWriter() {
        return this.writer;
    }

    protected final BufferedReader getReader() {
        return this.reader;
    }

    private void closeRemoteResources() {
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.reader = null;
        }
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
        if (this.socketOutstream != null) {
            try {
                this.socketOutstream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.socketOutstream = null;
        }
        if (this.socketInstream != null) {
            try {
                this.socketInstream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.socketInstream = null;
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.socket = null;
        }
    }

    protected String getJavaVmArguments() {
        return this.javaVmArguments;
    }
}

