/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.arquillian.daemon.server;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.DelimiterBasedFrameDecoder;
import io.netty.handler.codec.Delimiters;
import io.netty.handler.codec.string.StringDecoder;
import io.netty.util.concurrent.EventExecutorGroup;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.shrinkwrap.api.ConfigurationBuilder;
import org.jboss.shrinkwrap.api.Domain;
import org.jboss.shrinkwrap.api.GenericArchive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.wildfly.swarm.arquillian.daemon.TestRunner;
import org.wildfly.swarm.arquillian.daemon.protocol.WireProtocol;
import org.wildfly.swarm.arquillian.daemon.server.ServerLifecycleException;

public class Server {
    public static final int MAX_PORT = 65535;
    private DeploymentUnit deploymentUnit;
    private static final Logger log = Logger.getLogger(Server.class.getName());
    private static final String NAME_CHANNEL_HANDLER_STRING_DECODER = "StringDecoder";
    private static final String NAME_CHANNEL_HANDLER_FRAME_DECODER = "FrameDecoder";
    private static final String NAME_CHANNEL_HANDLER_COMMAND = "CommandHandler";
    private final List<EventLoopGroup> eventLoopGroups = new ArrayList<EventLoopGroup>();
    private final ConcurrentMap<String, GenericArchive> deployedArchives = new ConcurrentHashMap<String, GenericArchive>();
    private final Domain shrinkwrapDomain;
    private final InetSocketAddress bindAddress;
    private ExecutorService shutdownService;
    private boolean running;
    private Throwable error;

    Server(InetSocketAddress bindAddress) {
        assert (bindAddress != null) : "Bind address must be specified";
        ClassLoader thisCl = Server.class.getClassLoader();
        HashSet<ClassLoader> classloaders = new HashSet<ClassLoader>(1);
        classloaders.add(thisCl);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Using ClassLoader for ShrinkWrap Domain: " + thisCl);
        }
        this.shrinkwrapDomain = ShrinkWrap.createDomain((ConfigurationBuilder)new ConfigurationBuilder().classLoaders(classloaders));
        this.bindAddress = bindAddress;
    }

    public static Server create(String bindAddress, int bindPort) throws IllegalArgumentException {
        InetSocketAddress resolvedInetAddress;
        if (bindPort < 0 || bindPort > 65535) {
            throw new IllegalArgumentException("Bind port must be between 0 and 65535");
        }
        InetSocketAddress inetSocketAddress = resolvedInetAddress = bindAddress == null ? new InetSocketAddress(bindPort) : new InetSocketAddress(bindAddress, bindPort);
        if (resolvedInetAddress.isUnresolved()) {
            throw new IllegalArgumentException("Address \"" + bindAddress + "\" could not be resolved");
        }
        return new Server(resolvedInetAddress);
    }

    public final void start() throws ServerLifecycleException, IllegalStateException {
        ChannelFuture openChannel;
        if (this.isRunning()) {
            throw new IllegalStateException("Already running");
        }
        NioEventLoopGroup parentGroup = new NioEventLoopGroup();
        NioEventLoopGroup childGroup = new NioEventLoopGroup();
        this.eventLoopGroups.add((EventLoopGroup)parentGroup);
        this.eventLoopGroups.add((EventLoopGroup)childGroup);
        ServerBootstrap bootstrap = ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group((EventLoopGroup)parentGroup, (EventLoopGroup)childGroup).channel(NioServerSocketChannel.class)).localAddress((SocketAddress)this.getBindAddress())).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel channel) throws Exception {
                ChannelPipeline pipeline = channel.pipeline();
                Server.this.setupPipeline(pipeline);
            }
        }).childOption(ChannelOption.TCP_NODELAY, (Object)true).childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
        try {
            openChannel = bootstrap.bind().sync();
        }
        catch (InterruptedException ie) {
            Thread.interrupted();
            throw new ServerLifecycleException("Interrupted while awaiting server start", ie);
        }
        catch (RuntimeException re) {
            throw new ServerLifecycleException("Encountered error in binding; could not start server.", re);
        }
        InetSocketAddress boundAddress = (InetSocketAddress)openChannel.channel().localAddress();
        this.running = true;
        this.shutdownService = Executors.newSingleThreadExecutor();
        if (log.isLoggable(Level.INFO)) {
            log.info("Arquillian Daemon server started on " + boundAddress.getHostName() + ":" + boundAddress.getPort());
        }
    }

    public final synchronized void stop() throws ServerLifecycleException, IllegalStateException {
        Logger log = Logger.getAnonymousLogger();
        log.addHandler(new Handler(){
            private final String PREFIX = "[" + Server.class.getSimpleName() + "] ";

            @Override
            public void publish(LogRecord record) {
                System.out.println(this.PREFIX + record.getMessage());
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() throws SecurityException {
            }
        });
        if (!this.isRunning()) {
            throw new IllegalStateException("Server is not running");
        }
        if (log.isLoggable(Level.INFO)) {
            log.info("Requesting shutdown...");
        }
        this.eventLoopGroups.forEach(EventExecutorGroup::shutdownGracefully);
        this.eventLoopGroups.clear();
        this.shutdownService.shutdownNow();
        this.shutdownService = null;
        this.running = false;
        if (log.isLoggable(Level.INFO)) {
            log.info("Server shutdown.");
        }
    }

    public final boolean isRunning() {
        return this.running;
    }

    private static ChannelFuture sendResponse(ChannelHandlerContext ctx, String response) {
        ByteBuf buf = ctx.alloc().buffer();
        buf.writeBytes(response.getBytes(WireProtocol.CHARSET));
        ctx.write((Object)buf);
        return ctx.writeAndFlush((Object)Delimiters.lineDelimiter()[0]);
    }

    protected final InetSocketAddress getBindAddress() {
        return this.bindAddress;
    }

    protected final ConcurrentMap<String, GenericArchive> getDeployedArchives() {
        return this.deployedArchives;
    }

    protected final Domain getShrinkwrapDomain() {
        return this.shrinkwrapDomain;
    }

    public void setDeploymentUnit(DeploymentUnit deploymentUnit) {
        this.deploymentUnit = deploymentUnit;
    }

    public void setError(Throwable error) {
        this.error = error;
    }

    protected final Serializable executeTest(String testClassName, String methodName) {
        return new TestRunner(this.deploymentUnit).executeTest(testClassName, methodName);
    }

    protected Serializable checkDeployment() {
        return this.error;
    }

    protected final void stopAsync() {
        this.shutdownService.submit(() -> {
            this.stop();
            return null;
        });
    }

    private void setupPipeline(ChannelPipeline pipeline) {
        pipeline.addLast(NAME_CHANNEL_HANDLER_FRAME_DECODER, (ChannelHandler)new DelimiterBasedFrameDecoder(2000, Delimiters.lineDelimiter()));
        pipeline.addLast(NAME_CHANNEL_HANDLER_STRING_DECODER, (ChannelHandler)new StringDecoder(WireProtocol.CHARSET));
        pipeline.addLast(NAME_CHANNEL_HANDLER_COMMAND, (ChannelHandler)new StringCommandHandler());
    }

    private class StringCommandHandler
    extends SimpleChannelInboundHandler<String> {
        private StringCommandHandler() {
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            if (!Server.this.isRunning()) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Got exception while server is not running: " + cause.getMessage());
                }
                ctx.close();
            } else {
                super.exceptionCaught(ctx, cause);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void channelRead0(ChannelHandlerContext ctx, String message) throws Exception {
            block9: {
                try {
                    if ("CMD checkdeployment".equals(message)) {
                        Serializable error = Server.this.checkDeployment();
                        ObjectOutputStream objectOutstream = null;
                        ByteBuf out = ctx.alloc().buffer();
                        objectOutstream = new ObjectOutputStream((OutputStream)new ByteBufOutputStream(out));
                        objectOutstream.writeObject(error);
                        objectOutstream.flush();
                        ctx.writeAndFlush((Object)out);
                        break block9;
                    }
                    if ("CMD stop".equals(message)) {
                        Server.sendResponse(ctx, "OK " + message).addListener(future -> Server.this.stopAsync());
                        break block9;
                    }
                    if (message.startsWith("CMD test ")) {
                        StringTokenizer tokenizer = new StringTokenizer(message);
                        tokenizer.nextToken();
                        tokenizer.nextToken();
                        String testClassName = tokenizer.nextToken();
                        String methodName = tokenizer.nextToken();
                        Serializable testResult = Server.this.executeTest(testClassName, methodName);
                        try (ObjectOutputStream objectOutstream = null;){
                            ByteBuf out = ctx.alloc().buffer();
                            objectOutstream = new ObjectOutputStream((OutputStream)new ByteBufOutputStream(out));
                            objectOutstream.writeObject(testResult);
                            objectOutstream.flush();
                            ctx.writeAndFlush((Object)out);
                            break block9;
                        }
                    }
                    throw new UnsupportedOperationException("This server does not support command: " + message);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    Server.sendResponse(ctx, "ERR Caught unexpected error servicing request: " + t.getMessage());
                }
            }
        }
    }
}

