/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.arquillian.adapter;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.resolver.api.maven.ConfigurableMavenResolverSystem;
import org.jboss.shrinkwrap.resolver.api.maven.Maven;
import org.jboss.shrinkwrap.resolver.api.maven.MavenFormatStage;
import org.jboss.shrinkwrap.resolver.api.maven.MavenResolvedArtifact;
import org.jboss.shrinkwrap.resolver.api.maven.MavenStrategyStage;
import org.jboss.shrinkwrap.resolver.api.maven.PomEquippedResolveStage;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenCoordinate;
import org.jboss.shrinkwrap.resolver.api.maven.repository.MavenChecksumPolicy;
import org.jboss.shrinkwrap.resolver.api.maven.repository.MavenRemoteRepositories;
import org.jboss.shrinkwrap.resolver.api.maven.repository.MavenRemoteRepository;
import org.jboss.shrinkwrap.resolver.api.maven.repository.MavenUpdatePolicy;
import org.wildfly.swarm.arquillian.adapter.ShrinkwrapArtifactResolvingHelper;
import org.wildfly.swarm.arquillian.adapter.SimpleContainer;
import org.wildfly.swarm.arquillian.daemon.DaemonServiceActivator;
import org.wildfly.swarm.container.JARArchive;
import org.wildfly.swarm.msc.ServiceActivatorArchive;
import org.wildfly.swarm.tools.ArtifactResolvingHelper;
import org.wildfly.swarm.tools.BuildTool;
import org.wildfly.swarm.tools.exec.SwarmExecutor;
import org.wildfly.swarm.tools.exec.SwarmProcess;

public class UberjarSimpleContainer
implements SimpleContainer {
    private int timeout;
    private final Class<?> testClass;
    private SwarmProcess process;
    private Set<String> requestedMavenArtifacts;

    public UberjarSimpleContainer(Class<?> testClass) {
        this.testClass = testClass;
    }

    @Override
    public UberjarSimpleContainer requestedMavenArtifacts(Set<String> artifacts) {
        this.requestedMavenArtifacts = artifacts;
        return this;
    }

    @Override
    public void start(Archive<?> archive) throws Exception {
        String debug;
        boolean hasRequestedArtifacts;
        if (this.isContainerFactory(this.testClass)) {
            ((JARArchive)((JARArchive)((JavaArchive)((JavaArchive)((JavaArchive)archive.as(JavaArchive.class)).addAsServiceProvider("org.wildfly.swarm.ContainerFactory", new String[]{this.testClass.getName()})).addClass(this.testClass)).as(JARArchive.class)).addModule("org.wildfly.swarm.container")).addModule("org.wildfly.swarm.configuration");
        }
        ((ServiceActivatorArchive)archive.as(ServiceActivatorArchive.class)).addServiceActivator(DaemonServiceActivator.class);
        ((JARArchive)((JARArchive)archive.as(JARArchive.class)).addModule("org.wildfly.swarm.arquillian.daemon")).addModule("org.jboss.msc");
        BuildTool tool = new BuildTool().projectArchive(archive).bundleDependencies(false);
        String additionalModules = System.getProperty("swarm.build.modules");
        if (additionalModules != null) {
            tool.additionalModules((Collection)Stream.of(additionalModules.split(":")).map(m -> new File((String)m).getAbsolutePath()).collect(Collectors.toList()));
        }
        MavenRemoteRepository jbossPublic = MavenRemoteRepositories.createRemoteRepository((String)"jboss-public-repository-group", (String)"http://repository.jboss.org/nexus/content/groups/public/", (String)"default");
        jbossPublic.setChecksumPolicy(MavenChecksumPolicy.CHECKSUM_POLICY_IGNORE);
        jbossPublic.setUpdatePolicy(MavenUpdatePolicy.UPDATE_POLICY_NEVER);
        ConfigurableMavenResolverSystem resolver = (ConfigurableMavenResolverSystem)((ConfigurableMavenResolverSystem)Maven.configureResolver().withMavenCentralRepo(true)).withRemoteRepo(jbossPublic);
        SwarmExecutor executor = new SwarmExecutor().withDefaultSystemProperties();
        String additionalRepos = System.getProperty("swarm.build.repos");
        if (additionalRepos != null) {
            executor.withProperty("remote.maven.repo", additionalRepos);
            Arrays.asList(additionalRepos.split(",")).forEach(r -> {
                MavenRemoteRepository repo = MavenRemoteRepositories.createRemoteRepository((String)r, (String)r, (String)"default");
                repo.setChecksumPolicy(MavenChecksumPolicy.CHECKSUM_POLICY_IGNORE);
                repo.setUpdatePolicy(MavenUpdatePolicy.UPDATE_POLICY_NEVER);
                resolver.withRemoteRepo(repo);
            });
        }
        ShrinkwrapArtifactResolvingHelper resolvingHelper = new ShrinkwrapArtifactResolvingHelper(resolver);
        tool.artifactResolvingHelper((ArtifactResolvingHelper)resolvingHelper);
        boolean bl = hasRequestedArtifacts = this.requestedMavenArtifacts != null && this.requestedMavenArtifacts.size() > 0;
        if (!hasRequestedArtifacts) {
            MavenResolvedArtifact[] deps = resolvingHelper.withResolver(r -> (MavenResolvedArtifact[])((MavenFormatStage)((MavenStrategyStage)((PomEquippedResolveStage)((PomEquippedResolveStage)r.loadPomFromFile("pom.xml")).importRuntimeAndTestDependencies()).resolve()).withTransitivity()).asResolvedArtifact());
            for (MavenResolvedArtifact dep : deps) {
                MavenCoordinate coord = dep.getCoordinate();
                tool.dependency(dep.getScope().name(), coord.getGroupId(), coord.getArtifactId(), coord.getVersion(), coord.getPackaging().getExtension(), coord.getClassifier(), dep.asFile());
            }
        } else {
            this.requestedMavenArtifacts.add("org.wildfly.swarm:arquillian-daemon");
            for (String requestedDep : this.requestedMavenArtifacts) {
                MavenResolvedArtifact[] deps;
                for (MavenResolvedArtifact dep : deps = resolvingHelper.withResolver(r -> (MavenResolvedArtifact[])((MavenFormatStage)((MavenStrategyStage)((PomEquippedResolveStage)r.loadPomFromFile("pom.xml")).resolve(requestedDep)).withTransitivity()).asResolvedArtifact())) {
                    MavenCoordinate coord = dep.getCoordinate();
                    tool.dependency(dep.getScope().name(), coord.getGroupId(), coord.getArtifactId(), coord.getVersion(), coord.getPackaging().getExtension(), coord.getClassifier(), dep.asFile());
                }
            }
        }
        if ((debug = System.getProperty("swarm.debug.port")) != null && !"false".equals(debug)) {
            try {
                executor.withDebug(Integer.valueOf(Integer.parseInt(debug)));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(String.format("Failed to parse %s of \"%s\"", "swarm.debug.port", debug), e);
            }
        }
        Archive wrapped = tool.build();
        String dump = System.getProperty("swarm.export.uberjar");
        if (dump != null && !"false".equals(dump)) {
            File out = new File(wrapped.getName());
            System.err.println("Dumping swarmjar to " + out.getAbsolutePath());
            ((ZipExporter)wrapped.as(ZipExporter.class)).exportTo(out, true);
        }
        File executable = File.createTempFile("arquillian", "-swarm.jar");
        ((ZipExporter)wrapped.as(ZipExporter.class)).exportTo(executable, true);
        executable.deleteOnExit();
        executor.withProperty("java.net.preferIPv4Stack", "true");
        executor.withExecutableJar(executable.toPath());
        File workingDirectory = Files.createTempDirectory("arquillian", new FileAttribute[0]).toFile();
        workingDirectory.deleteOnExit();
        executor.withWorkingDirectory(workingDirectory.toPath());
        this.process = executor.execute();
        this.process.getOutputStream().close();
        this.process.awaitDeploy(2L, TimeUnit.MINUTES);
        if (!this.process.isAlive()) {
            throw new DeploymentException("Process failed to start");
        }
        if (this.process.getError() != null) {
            throw new DeploymentException("Error starting process", (Throwable)this.process.getError());
        }
    }

    @Override
    public void stop() throws Exception {
        this.process.stop();
    }
}

