/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.arquillian.adapter;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class ReflectionHelper {
    private ReflectionHelper() {
        throw new UnsupportedOperationException("No instantiation");
    }

    public static ClassLoader getThreadContextClassLoader() {
        return AccessController.doPrivileged(GetTcclAction.INSTANCE);
    }

    public static Constructor<?> getConstructor(Class<?> clazz, Class<?> ... argumentTypes) throws NoSuchMethodException {
        try {
            return AccessController.doPrivileged(() -> clazz.getConstructor(argumentTypes));
        }
        catch (PrivilegedActionException pae) {
            Throwable t = pae.getCause();
            if (t instanceof NoSuchMethodException) {
                throw (NoSuchMethodException)t;
            }
            try {
                throw (RuntimeException)t;
            }
            catch (ClassCastException cce) {
                throw new RuntimeException("Obtained unchecked Exception; this code should never be reached", t);
            }
        }
    }

    public static <T> Constructor<T> getAssignableConstructor(Class<T> clazz, Class<?> ... argumentTypes) throws NoSuchMethodException {
        for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
            if (constructor.getParameterTypes().length != argumentTypes.length) continue;
            boolean found = true;
            for (int i = 0; i < argumentTypes.length; ++i) {
                if (constructor.getParameterTypes()[i].isAssignableFrom(argumentTypes[i])) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return constructor;
        }
        throw new NoSuchMethodException("There is no constructor in class " + clazz.getName() + " with arguments " + Arrays.toString(argumentTypes));
    }

    public static boolean hasConstructor(Class<?> clazz, Class<?> ... argumentTypes) {
        try {
            clazz.getDeclaredConstructor(argumentTypes);
            return true;
        }
        catch (NoSuchMethodException ignored) {
            return false;
        }
    }

    public static <T> T newInstance(String className, Class<?>[] argumentTypes, Object[] arguments, Class<T> expectedType) {
        Object obj;
        if (className == null) {
            throw new IllegalArgumentException("ClassName must be specified");
        }
        if (argumentTypes == null) {
            throw new IllegalArgumentException("ArgumentTypes must be specified. Use empty array if no arguments");
        }
        if (arguments == null) {
            throw new IllegalArgumentException("Arguments must be specified. Use empty array if no arguments");
        }
        try {
            ClassLoader tccl = ReflectionHelper.getThreadContextClassLoader();
            Class<?> implClass = Class.forName(className, false, tccl);
            Constructor<?> constructor = ReflectionHelper.getConstructor(implClass, argumentTypes);
            obj = constructor.newInstance(arguments);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create new instance of " + className + ", missing package from classpath?", e);
        }
        try {
            return expectedType.cast(obj);
        }
        catch (ClassCastException cce) {
            throw new ClassCastException("Incorrect expected type, " + expectedType.getName() + ", defined for " + obj.getClass().getName());
        }
    }

    public static boolean isClassPresent(String name) {
        try {
            ClassLoader classLoader = ReflectionHelper.getThreadContextClassLoader();
            classLoader.loadClass(name);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static List<Field> getFields(Class<?> source) {
        return AccessController.doPrivileged(() -> {
            ArrayList foundFields = new ArrayList();
            for (Class nextSource = source; nextSource != Object.class; nextSource = nextSource.getSuperclass()) {
                Collections.addAll(foundFields, nextSource.getDeclaredFields());
            }
            return foundFields;
        });
    }

    public static List<Field> getFieldsWithAnnotation(Class<?> source, Class<? extends Annotation> annotationClass) {
        List declaredAccessableFields = AccessController.doPrivileged(() -> {
            ArrayList<Field> foundFields = new ArrayList<Field>();
            for (Class nextSource = source; nextSource != Object.class; nextSource = nextSource.getSuperclass()) {
                for (Field field : nextSource.getDeclaredFields()) {
                    if (!field.isAnnotationPresent(annotationClass)) continue;
                    if (!field.isAccessible()) {
                        field.setAccessible(true);
                    }
                    foundFields.add(field);
                }
            }
            return foundFields;
        });
        return declaredAccessableFields;
    }

    public static List<Field> getFieldsWithAnnotatedAnnotation(Class<?> source, Class<? extends Annotation> annotationClass) {
        List declaredAccessableFields = AccessController.doPrivileged(() -> {
            ArrayList<Field> foundFields = new ArrayList<Field>();
            for (Class nextSource = source; nextSource != Object.class; nextSource = nextSource.getSuperclass()) {
                block1: for (Field field : nextSource.getDeclaredFields()) {
                    for (Annotation annotation : field.getAnnotations()) {
                        if (!annotation.annotationType().isAnnotationPresent(annotationClass)) continue;
                        if (!field.isAccessible()) {
                            field.setAccessible(true);
                        }
                        foundFields.add(field);
                        continue block1;
                    }
                }
            }
            return foundFields;
        });
        return declaredAccessableFields;
    }

    public static List<Method> getMethodsWithAnnotation(Class<?> source, Class<? extends Annotation> annotationClass) {
        List declaredAccessableMethods = AccessController.doPrivileged(() -> {
            ArrayList<Method> foundMethods = new ArrayList<Method>();
            for (Method method : source.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(annotationClass)) continue;
                if (!method.isAccessible()) {
                    method.setAccessible(true);
                }
                foundMethods.add(method);
            }
            return foundMethods;
        });
        return declaredAccessableMethods;
    }

    private static enum GetTcclAction implements PrivilegedAction<ClassLoader>
    {
        INSTANCE;


        @Override
        public ClassLoader run() {
            return Thread.currentThread().getContextClassLoader();
        }
    }
}

