/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.arquillian.resources;

import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.jboss.arquillian.container.test.impl.enricher.resource.OperatesOnDeploymentAwareProvider;
import org.jboss.arquillian.test.api.ArquillianResource;

public class SwarmURLResourceProvider
extends OperatesOnDeploymentAwareProvider {
    public boolean canProvide(Class<?> type) {
        return URL.class.isAssignableFrom(type);
    }

    public Object doLookup(ArquillianResource resource, Annotation ... __) {
        String contextPath;
        String host = System.getProperty("swarm.bind.address");
        if (host == null || host.equals("0.0.0.0")) {
            host = "localhost";
        }
        int port = 8080;
        String portString = System.getProperty("swarm.http.port");
        if (portString != null) {
            port = Integer.parseInt(portString);
        }
        if ((contextPath = System.getProperty("swarm.context.path")) == null) {
            contextPath = "/";
        }
        try {
            return new URI("http", null, host, port, contextPath, null, null).toURL();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

