/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.arquillian.adapter;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.context.ContainerContext;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.resolver.api.maven.MavenFormatStage;
import org.jboss.shrinkwrap.resolver.api.maven.MavenResolvedArtifact;
import org.jboss.shrinkwrap.resolver.api.maven.MavenStrategyStage;
import org.jboss.shrinkwrap.resolver.api.maven.PomEquippedResolveStage;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenCoordinate;
import org.wildfly.swarm.arquillian.WithMain;
import org.wildfly.swarm.arquillian.adapter.MainSpecifier;
import org.wildfly.swarm.arquillian.adapter.SimpleContainer;
import org.wildfly.swarm.arquillian.daemon.DaemonServiceActivator;
import org.wildfly.swarm.arquillian.resolver.ShrinkwrapArtifactResolvingHelper;
import org.wildfly.swarm.bootstrap.util.BootstrapProperties;
import org.wildfly.swarm.msc.ServiceActivatorArchive;
import org.wildfly.swarm.spi.api.JARArchive;
import org.wildfly.swarm.tools.ArtifactResolvingHelper;
import org.wildfly.swarm.tools.BuildTool;
import org.wildfly.swarm.tools.exec.SwarmExecutor;
import org.wildfly.swarm.tools.exec.SwarmProcess;

public class UberjarSimpleContainer
implements SimpleContainer {
    private final ContainerContext containerContext;
    private final Class<?> testClass;
    private SwarmProcess process;
    private Set<String> requestedMavenArtifacts;

    public UberjarSimpleContainer(ContainerContext containerContext, Class<?> testClass) {
        this.containerContext = containerContext;
        this.testClass = testClass;
    }

    @Override
    public UberjarSimpleContainer requestedMavenArtifacts(Set<String> artifacts) {
        this.requestedMavenArtifacts = artifacts;
        return this;
    }

    @Override
    public void start(Archive<?> archive) throws Exception {
        String debug;
        boolean hasRequestedArtifacts;
        MainSpecifier mainSpecifier = (MainSpecifier)this.containerContext.getObjectStore().get(MainSpecifier.class);
        if (this.isContainerFactory(this.testClass)) {
            ((JARArchive)((JARArchive)((JavaArchive)((JavaArchive)((JavaArchive)archive.as(JavaArchive.class)).addAsServiceProvider("org.wildfly.swarm.ContainerFactory", new String[]{this.testClass.getName()})).addClass(this.testClass)).as(JARArchive.class)).addModule("org.wildfly.swarm.container")).addModule("org.wildfly.swarm.configuration");
        }
        ((ServiceActivatorArchive)archive.as(ServiceActivatorArchive.class)).addServiceActivator(DaemonServiceActivator.class);
        ((JARArchive)((JARArchive)((JARArchive)archive.as(JARArchive.class)).addModule("org.wildfly.swarm.arquillian.daemon")).addModule("org.jboss.modules")).addModule("org.jboss.msc");
        BuildTool tool = new BuildTool().projectArchive(archive).fractionDetectionMode(BuildTool.FractionDetectionMode.never).bundleDependencies(false);
        String additionalModules = System.getProperty("swarm.build.modules");
        if (additionalModules != null) {
            tool.additionalModules((Collection)Stream.of(additionalModules.split(":")).map(File::new).filter(File::exists).map(File::getAbsolutePath).collect(Collectors.toList()));
        }
        SwarmExecutor executor = new SwarmExecutor().withDefaultSystemProperties();
        String additionalRepos = System.getProperty("swarm.build.repos");
        if (additionalRepos != null) {
            executor.withProperty("remote.maven.repo", additionalRepos);
        }
        ShrinkwrapArtifactResolvingHelper resolvingHelper = ShrinkwrapArtifactResolvingHelper.defaultInstance();
        tool.artifactResolvingHelper((ArtifactResolvingHelper)resolvingHelper);
        boolean bl = hasRequestedArtifacts = this.requestedMavenArtifacts != null && this.requestedMavenArtifacts.size() > 0;
        if (!hasRequestedArtifacts) {
            MavenResolvedArtifact[] deps = resolvingHelper.withResolver(r -> (MavenResolvedArtifact[])((MavenFormatStage)((MavenStrategyStage)((PomEquippedResolveStage)((PomEquippedResolveStage)r.loadPomFromFile("pom.xml")).importRuntimeAndTestDependencies()).resolve()).withTransitivity()).asResolvedArtifact());
            for (MavenResolvedArtifact dep : deps) {
                MavenCoordinate coord = dep.getCoordinate();
                tool.dependency(dep.getScope().name(), coord.getGroupId(), coord.getArtifactId(), coord.getVersion(), coord.getPackaging().getExtension(), coord.getClassifier(), dep.asFile());
            }
        } else {
            this.requestedMavenArtifacts.add("org.wildfly.swarm:arquillian-daemon");
            for (String requestedDep : this.requestedMavenArtifacts) {
                MavenResolvedArtifact[] deps;
                for (MavenResolvedArtifact dep : deps = resolvingHelper.withResolver(r -> (MavenResolvedArtifact[])((MavenFormatStage)((MavenStrategyStage)((PomEquippedResolveStage)r.loadPomFromFile("pom.xml")).resolve(requestedDep)).withTransitivity()).asResolvedArtifact())) {
                    MavenCoordinate coord = dep.getCoordinate();
                    tool.dependency(dep.getScope().name(), coord.getGroupId(), coord.getArtifactId(), coord.getVersion(), coord.getPackaging().getExtension(), coord.getClassifier(), dep.asFile());
                }
            }
        }
        if ((debug = System.getProperty("swarm.debug.port")) != null) {
            try {
                executor.withDebug(Integer.valueOf(Integer.parseInt(debug)));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(String.format("Failed to parse %s of \"%s\"", "swarm.debug.port", debug), e);
            }
        }
        if (mainSpecifier != null) {
            String[] args;
            tool.mainClass(mainSpecifier.getClassName());
            for (String arg : args = mainSpecifier.getArgs()) {
                executor.withArgument(arg);
            }
        } else {
            WithMain withMainAnno = this.testClass.getAnnotation(WithMain.class);
            if (withMainAnno != null) {
                tool.mainClass(withMainAnno.value().getName());
            }
        }
        Archive wrapped = tool.build();
        if (BootstrapProperties.flagIsSet((String)"swarm.export.uberjar")) {
            File out = new File(wrapped.getName());
            System.err.println("Exporting swarm jar to " + out.getAbsolutePath());
            ((ZipExporter)wrapped.as(ZipExporter.class)).exportTo(out, true);
        }
        File executable = File.createTempFile("arquillian", "-swarm.jar");
        ((ZipExporter)wrapped.as(ZipExporter.class)).exportTo(executable, true);
        executable.deleteOnExit();
        executor.withProperty("java.net.preferIPv4Stack", "true");
        executor.withExecutableJar(executable.toPath());
        File workingDirectory = Files.createTempDirectory("arquillian", new FileAttribute[0]).toFile();
        workingDirectory.deleteOnExit();
        executor.withWorkingDirectory(workingDirectory.toPath());
        this.process = executor.execute();
        this.process.getOutputStream().close();
        this.process.awaitDeploy(2L, TimeUnit.MINUTES);
        if (!this.process.isAlive()) {
            throw new DeploymentException("Process failed to start");
        }
        if (this.process.getError() != null) {
            throw new DeploymentException("Error starting process", (Throwable)this.process.getError());
        }
    }

    @Override
    public void stop() throws Exception {
        this.process.stop();
    }

    private String ga(MavenCoordinate coord) {
        return String.format("%s:%s", coord.getGroupId(), coord.getArtifactId());
    }

    private String gav(MavenCoordinate coord) {
        return this.gav(coord.getGroupId(), coord.getArtifactId(), coord.getVersion());
    }

    private String gav(String group, String artifact, String version) {
        return String.format("%s:%s:%s", group, artifact, version);
    }
}

