/**
 * Copyright 2015-2016 Red Hat, Inc, and individual contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.wildfly.swarm.arquillian.adapter;

import org.jboss.shrinkwrap.api.Archive;
import org.wildfly.swarm.ContainerFactory;
import org.wildfly.swarm.arquillian.daemon.DaemonServiceActivator;
import org.wildfly.swarm.bootstrap.util.BootstrapProperties;
import org.wildfly.swarm.container.Container;
import org.wildfly.swarm.msc.ServiceActivatorArchive;
import org.wildfly.swarm.spi.api.JARArchive;

/**
 * @author Toby Crawley
 */
public class InVMSimpleContainer implements SimpleContainer {
    public InVMSimpleContainer(Class<?> testClass) {
        this.testClass = testClass;
    }

    @Override
    public void start(Archive<?> archive) throws Exception {
        archive.as(ServiceActivatorArchive.class)
                .addServiceActivator(DaemonServiceActivator.class)
                .as(JARArchive.class)
                .addModule("org.wildfly.swarm.arquillian.daemon");

        System.setProperty(BootstrapProperties.APP_ARTIFACT, archive.getName());

        if (isContainerFactory(this.testClass)) {
            archive.as(JARArchive.class).addModule("org.wildfly.swarm.container");
            archive.as(JARArchive.class).addModule("org.wildfly.swarm.configuration");
            Object factory = this.testClass.newInstance();
            this.container = ((ContainerFactory) factory).newContainer();
        } else {
            this.container = new Container();
        }
        this.container.start().deploy(archive);
    }

    @Override
    public void stop() throws Exception {
        if (container != null) {
            container.stop();
        }
    }

    private final Class<?> testClass;

    private Container container;
}
