/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.arquillian.adapter;

import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.arquillian.container.spi.event.container.AfterSetup;
import org.jboss.arquillian.container.test.impl.client.deployment.event.GenerateDeployment;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.shrinkwrap.resolver.api.maven.MavenFormatStage;
import org.jboss.shrinkwrap.resolver.api.maven.MavenResolvedArtifact;
import org.jboss.shrinkwrap.resolver.api.maven.MavenStrategyStage;
import org.jboss.shrinkwrap.resolver.api.maven.PomEquippedResolveStage;
import org.jboss.shrinkwrap.resolver.api.maven.ScopeType;
import org.wildfly.swarm.arquillian.ArtifactDependencies;
import org.wildfly.swarm.arquillian.adapter.WildFlySwarmContainer;
import org.wildfly.swarm.arquillian.resolver.ShrinkwrapArtifactResolvingHelper;

public class WildFlySwarmObserver {
    private WildFlySwarmContainer container;

    public void afterSetup(@Observes AfterSetup event) throws Exception {
        this.container = (WildFlySwarmContainer)event.getDeployableContainer();
    }

    public void generate(@Observes(precedence=100) GenerateDeployment event) throws Exception {
        Class testClass = event.getTestClass().getJavaClass();
        this.container.setTestClass(testClass);
        List annotatedMethods = Stream.of(testClass.getDeclaredMethods()).filter(m -> m.isAnnotationPresent(ArtifactDependencies.class)).collect(Collectors.toList());
        if (annotatedMethods.size() > 1) {
            throw new IllegalArgumentException("Too many methods annotated with " + ArtifactDependencies.class.getName());
        }
        if (annotatedMethods.size() == 1) {
            Method dependencyMethod = (Method)annotatedMethods.get(0);
            dependencyMethod.setAccessible(true);
            this.validate(dependencyMethod);
            this.container.setRequestedMavenArtifacts((List)dependencyMethod.invoke(null, new Object[0]));
        }
        ShrinkwrapArtifactResolvingHelper resolvingHelper = ShrinkwrapArtifactResolvingHelper.defaultInstance();
        MavenResolvedArtifact[] deps = resolvingHelper.withResolver(r -> (MavenResolvedArtifact[])((MavenFormatStage)((MavenStrategyStage)((PomEquippedResolveStage)((PomEquippedResolveStage)r.loadPomFromFile("pom.xml")).importDependencies(new ScopeType[]{ScopeType.TEST, ScopeType.PROVIDED})).resolve()).withTransitivity()).asResolvedArtifact());
        StringBuffer buffer = new StringBuffer();
        for (MavenResolvedArtifact artifact : deps) {
            buffer.append(artifact.asFile().getAbsolutePath());
            buffer.append(File.pathSeparator);
        }
        System.setProperty("swarm.test.dependencies", buffer.toString());
    }

    private void validate(Method dependencyMethod) {
        if (!Modifier.isStatic(dependencyMethod.getModifiers())) {
            throw new IllegalArgumentException("Method annotated with " + ArtifactDependencies.class.getName() + " is not static. " + dependencyMethod);
        }
        if (!List.class.isAssignableFrom(dependencyMethod.getReturnType())) {
            throw new IllegalArgumentException("Method annotated with " + ArtifactDependencies.class.getName() + " must have return type " + List.class.getName() + ". " + dependencyMethod);
        }
        if (dependencyMethod.getParameterTypes().length != 0) {
            throw new IllegalArgumentException("Method annotated with " + ArtifactDependencies.class.getName() + " can not accept parameters. " + dependencyMethod);
        }
    }
}

