/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.arquillian.adapter;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.StringTokenizer;
import org.jboss.shrinkwrap.api.Archive;
import org.wildfly.swarm.ContainerFactory;
import org.wildfly.swarm.arquillian.adapter.Container;
import org.wildfly.swarm.arquillian.adapter.SimpleContainer;
import org.wildfly.swarm.arquillian.daemon.DaemonServiceActivator;
import org.wildfly.swarm.msc.ServiceActivatorArchive;
import org.wildfly.swarm.spi.api.JARArchive;

public class InVMSimpleContainer
implements SimpleContainer {
    private final Class<?> testClass;
    private org.wildfly.swarm.container.Container container;
    private String javaVmArguments;

    public InVMSimpleContainer(Class<?> testClass) {
        this.testClass = testClass;
    }

    @Override
    public InVMSimpleContainer setJavaVmArguments(String javaVmArguments) {
        this.javaVmArguments = javaVmArguments;
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void start(Archive<?> archive) throws Exception {
        ((JARArchive)((ServiceActivatorArchive)archive.as(ServiceActivatorArchive.class)).addServiceActivator(DaemonServiceActivator.class).as(JARArchive.class)).addModule("org.wildfly.swarm.arquillian.daemon");
        System.setProperty("swarm.app.artifact", archive.getName());
        if (this.isContainerFactory(this.testClass)) {
            ((JARArchive)archive.as(JARArchive.class)).addModule("org.wildfly.swarm.container");
            ((JARArchive)archive.as(JARArchive.class)).addModule("org.wildfly.swarm.configuration");
            Object factory = this.testClass.newInstance();
            this.container = ((ContainerFactory)factory).newContainer(new String[0]);
        } else {
            Method containerMethod = this.getAnnotatedMethodWithAnnotation(this.testClass, Container.class);
            if (containerMethod != null) {
                if (!Modifier.isStatic(containerMethod.getModifiers())) throw new IllegalArgumentException(String.format("Method annotated with %s is %s but it is not static", Container.class.getSimpleName(), containerMethod));
                Object container = containerMethod.invoke(null, new Object[0]);
                if (!(container instanceof org.wildfly.swarm.container.Container)) throw new IllegalArgumentException(String.format("Method annotated with %s does not return an instance of %s", Container.class.getSimpleName(), org.wildfly.swarm.container.Container.class.getSimpleName()));
                this.container = (org.wildfly.swarm.container.Container)container;
            } else {
                Method containerFactoryMethod = this.getAnnotatedMethodWithAnnotation(this.testClass, org.wildfly.swarm.arquillian.adapter.ContainerFactory.class);
                if (containerFactoryMethod != null) {
                    if (!Modifier.isStatic(containerFactoryMethod.getModifiers())) throw new IllegalArgumentException(String.format("Method annotated with %s is %s but it is not static", org.wildfly.swarm.arquillian.adapter.ContainerFactory.class.getSimpleName(), containerMethod));
                    Object containerFactory = containerFactoryMethod.invoke(null, new Object[0]);
                    if (!(containerFactory instanceof Class)) throw new IllegalArgumentException(String.format("Method annotated with %s does not return a class of %s", org.wildfly.swarm.arquillian.adapter.ContainerFactory.class.getSimpleName(), ContainerFactory.class.getSimpleName()));
                    Class containerFactoryClass = (Class)containerFactory;
                    if (!ContainerFactory.class.isAssignableFrom(containerFactoryClass)) throw new IllegalArgumentException(String.format("Method annotated with %s does not return a class of %s", org.wildfly.swarm.arquillian.adapter.ContainerFactory.class.getSimpleName(), ContainerFactory.class.getSimpleName()));
                    Object factory = containerFactoryClass.newInstance();
                    this.container = ((ContainerFactory)factory).newContainer(new String[0]);
                } else {
                    this.container = new org.wildfly.swarm.container.Container();
                }
            }
        }
        this.handleJavaVmArguments();
        this.container.start().deploy(archive);
    }

    private void handleJavaVmArguments() {
        if (this.javaVmArguments == null) {
            return;
        }
        StringTokenizer tokens = new StringTokenizer(this.javaVmArguments);
        while (tokens.hasMoreTokens()) {
            String each = tokens.nextToken();
            if (!each.startsWith("-D")) {
                System.err.println("ignoring non-property Java VM argument for InVM test: " + each);
                continue;
            }
            int equalLoc = (each = each.substring(2)).indexOf("=");
            if (equalLoc < 0) {
                System.setProperty(each, "true");
                continue;
            }
            String key = each.substring(0, equalLoc);
            String value = each.substring(equalLoc + 1);
            System.setProperty(key, value);
        }
    }

    @Override
    public void stop() throws Exception {
        if (this.container != null) {
            this.container.stop();
        }
    }
}

