/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.arquillian.adapter;

import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.context.ContainerContext;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.container.ClassContainer;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.resolver.api.maven.MavenFormatStage;
import org.jboss.shrinkwrap.resolver.api.maven.MavenResolvedArtifact;
import org.jboss.shrinkwrap.resolver.api.maven.MavenStrategyStage;
import org.jboss.shrinkwrap.resolver.api.maven.PomEquippedResolveStage;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenCoordinate;
import org.wildfly.swarm.Swarm;
import org.wildfly.swarm.arquillian.CreateSwarm;
import org.wildfly.swarm.arquillian.adapter.AnnotationBasedMain;
import org.wildfly.swarm.arquillian.adapter.MainSpecifier;
import org.wildfly.swarm.arquillian.adapter.MavenProfileLoader;
import org.wildfly.swarm.arquillian.adapter.SimpleContainer;
import org.wildfly.swarm.arquillian.daemon.DaemonServiceActivator;
import org.wildfly.swarm.arquillian.resolver.ShrinkwrapArtifactResolvingHelper;
import org.wildfly.swarm.bootstrap.util.BootstrapProperties;
import org.wildfly.swarm.msc.ServiceActivatorArchive;
import org.wildfly.swarm.spi.api.JARArchive;
import org.wildfly.swarm.tools.ArtifactResolvingHelper;
import org.wildfly.swarm.tools.BuildTool;
import org.wildfly.swarm.tools.exec.SwarmExecutor;
import org.wildfly.swarm.tools.exec.SwarmProcess;

public class UberjarSimpleContainer
implements SimpleContainer {
    private final ContainerContext containerContext;
    private final Class<?> testClass;
    private SwarmProcess process;
    private Set<String> requestedMavenArtifacts;
    private String javaVmArguments;

    public UberjarSimpleContainer(ContainerContext containerContext, Class<?> testClass) {
        this.containerContext = containerContext;
        this.testClass = testClass;
    }

    @Override
    public UberjarSimpleContainer requestedMavenArtifacts(Set<String> artifacts) {
        this.requestedMavenArtifacts = artifacts;
        return this;
    }

    @Override
    public UberjarSimpleContainer setJavaVmArguments(String javaVmArguments) {
        this.javaVmArguments = javaVmArguments;
        return this;
    }

    @Override
    public void start(Archive<?> archive) throws Exception {
        String debug;
        boolean hasRequestedArtifacts;
        String additionalRepos;
        MainSpecifier mainSpecifier = (MainSpecifier)this.containerContext.getObjectStore().get(MainSpecifier.class);
        boolean annotatedCreateSwarm = false;
        Method swarmMethod = this.getAnnotatedMethodWithAnnotation(this.testClass, CreateSwarm.class);
        List<Class<?>> types = this.determineTypes(this.testClass);
        if (swarmMethod != null) {
            if (Modifier.isStatic(swarmMethod.getModifiers())) {
                annotatedCreateSwarm = true;
                types.add(CreateSwarm.class);
                types.add(AnnotationBasedMain.class);
                ((JARArchive)archive.as(JARArchive.class)).addModule("org.wildfly.swarm.container");
                ((JARArchive)archive.as(JARArchive.class)).addModule("org.wildfly.swarm.configuration");
            } else {
                throw new IllegalArgumentException(String.format("Method annotated with %s is %s but it is not static", CreateSwarm.class.getSimpleName(), swarmMethod));
            }
        }
        if (types.size() > 0) {
            try {
                ((ClassContainer)archive).addClasses(types.toArray(new Class[types.size()]));
            }
            catch (UnsupportedOperationException e) {
                ((JARArchive)archive.as(JARArchive.class)).addClasses(types.toArray(new Class[types.size()]));
            }
        }
        ((ServiceActivatorArchive)archive.as(ServiceActivatorArchive.class)).addServiceActivator(DaemonServiceActivator.class);
        ((JARArchive)archive.as(JARArchive.class)).addModule("org.wildfly.swarm.arquillian.daemon");
        ((JARArchive)archive.as(JARArchive.class)).addModule("org.jboss.modules");
        ((JARArchive)archive.as(JARArchive.class)).addModule("org.jboss.msc");
        BuildTool tool = new BuildTool().projectArchive(archive).fractionDetectionMode(BuildTool.FractionDetectionMode.never).bundleDependencies(false);
        String additionalModules = System.getProperty("swarm.build.modules");
        if (null == additionalModules) {
            File modulesDir = new File("target/classes/modules");
            String string = additionalModules = modulesDir.exists() ? modulesDir.getAbsolutePath() : null;
        }
        if (additionalModules != null) {
            tool.additionalModules((Collection)Stream.of(additionalModules.split(":")).map(File::new).filter(File::exists).map(File::getAbsolutePath).collect(Collectors.toList()));
        }
        SwarmExecutor executor = new SwarmExecutor().withDefaultSystemProperties();
        if (annotatedCreateSwarm) {
            executor.withProperty("swarm.arquillian.createswarm.class", this.testClass.getName());
        }
        if ((additionalRepos = System.getProperty("swarm.build.repos")) != null) {
            executor.withProperty("remote.maven.repo", additionalRepos);
        }
        ShrinkwrapArtifactResolvingHelper resolvingHelper = ShrinkwrapArtifactResolvingHelper.defaultInstance();
        tool.artifactResolvingHelper((ArtifactResolvingHelper)resolvingHelper);
        boolean bl = hasRequestedArtifacts = this.requestedMavenArtifacts != null && this.requestedMavenArtifacts.size() > 0;
        if (!hasRequestedArtifacts) {
            MavenResolvedArtifact[] presolvedDeps;
            MavenResolvedArtifact[] explicitDeps = resolvingHelper.withResolver(r -> (MavenResolvedArtifact[])((MavenFormatStage)((MavenStrategyStage)((PomEquippedResolveStage)MavenProfileLoader.loadPom(r).importRuntimeAndTestDependencies()).resolve()).withoutTransitivity()).asResolvedArtifact());
            for (MavenResolvedArtifact dep : explicitDeps) {
                MavenCoordinate mavenCoordinate = dep.getCoordinate();
                tool.explicitDependency(dep.getScope().name(), mavenCoordinate.getGroupId(), mavenCoordinate.getArtifactId(), mavenCoordinate.getVersion(), mavenCoordinate.getPackaging().getExtension(), mavenCoordinate.getClassifier(), dep.asFile());
            }
            for (MavenResolvedArtifact mavenResolvedArtifact : presolvedDeps = resolvingHelper.withResolver(r -> (MavenResolvedArtifact[])((MavenFormatStage)((MavenStrategyStage)((PomEquippedResolveStage)MavenProfileLoader.loadPom(r).importRuntimeAndTestDependencies()).resolve()).withTransitivity()).asResolvedArtifact())) {
                MavenCoordinate coord = mavenResolvedArtifact.getCoordinate();
                tool.presolvedDependency(mavenResolvedArtifact.getScope().name(), coord.getGroupId(), coord.getArtifactId(), coord.getVersion(), coord.getPackaging().getExtension(), coord.getClassifier(), mavenResolvedArtifact.asFile());
            }
        } else {
            this.requestedMavenArtifacts.add("org.wildfly.swarm:arquillian-daemon");
            for (String requestedDep : this.requestedMavenArtifacts) {
                MavenResolvedArtifact[] presolvedDeps;
                MavenResolvedArtifact[] mavenResolvedArtifactArray;
                for (MavenResolvedArtifact dep : mavenResolvedArtifactArray = resolvingHelper.withResolver(r -> (MavenResolvedArtifact[])((MavenFormatStage)((MavenStrategyStage)MavenProfileLoader.loadPom(r).resolve(requestedDep)).withoutTransitivity()).asResolvedArtifact())) {
                    MavenCoordinate coord = dep.getCoordinate();
                    tool.explicitDependency(dep.getScope().name(), coord.getGroupId(), coord.getArtifactId(), coord.getVersion(), coord.getPackaging().getExtension(), coord.getClassifier(), dep.asFile());
                }
                for (MavenResolvedArtifact dep : presolvedDeps = resolvingHelper.withResolver(r -> (MavenResolvedArtifact[])((MavenFormatStage)((MavenStrategyStage)MavenProfileLoader.loadPom(r).resolve(requestedDep)).withTransitivity()).asResolvedArtifact())) {
                    MavenCoordinate coord = dep.getCoordinate();
                    tool.presolvedDependency(dep.getScope().name(), coord.getGroupId(), coord.getArtifactId(), coord.getVersion(), coord.getPackaging().getExtension(), coord.getClassifier(), dep.asFile());
                }
            }
        }
        if ((debug = System.getProperty("swarm.debug.port")) != null) {
            try {
                executor.withDebug(Integer.valueOf(Integer.parseInt(debug)));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(String.format("Failed to parse %s of \"%s\"", "swarm.debug.port", debug), e);
            }
        }
        if (mainSpecifier != null) {
            String[] args;
            tool.mainClass(mainSpecifier.getClassName());
            for (String string : args = mainSpecifier.getArgs()) {
                executor.withArgument(string);
            }
        } else if (annotatedCreateSwarm) {
            tool.mainClass(AnnotationBasedMain.class.getName());
        } else {
            tool.mainClass(Swarm.class.getName());
        }
        Archive wrapped = null;
        try {
            wrapped = tool.build();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw throwable;
        }
        if (BootstrapProperties.flagIsSet((String)"swarm.export.uberjar")) {
            File file = new File(wrapped.getName());
            System.err.println("Exporting swarm jar to " + file.getAbsolutePath());
            ((ZipExporter)wrapped.as(ZipExporter.class)).exportTo(file, true);
        }
        File file = File.createTempFile("arquillian", "-swarm.jar");
        ((ZipExporter)wrapped.as(ZipExporter.class)).exportTo(file, true);
        file.deleteOnExit();
        executor.withProperty("java.net.preferIPv4Stack", "true");
        executor.withJVMArguments(this.getJavaVmArgumentsList());
        executor.withExecutableJar(file.toPath());
        File workingDirectory = Files.createTempDirectory("arquillian", new FileAttribute[0]).toFile();
        workingDirectory.deleteOnExit();
        executor.withWorkingDirectory(workingDirectory.toPath());
        this.process = executor.execute();
        this.process.getOutputStream().close();
        this.process.awaitDeploy(2L, TimeUnit.MINUTES);
        if (!this.process.isAlive()) {
            throw new DeploymentException("Process failed to start");
        }
        if (this.process.getError() != null) {
            throw new DeploymentException("Error starting process", (Throwable)this.process.getError());
        }
    }

    private List<Class<?>> determineTypes(Class<?> testClass) {
        ArrayList types = new ArrayList();
        for (Class<?> clazz = testClass; clazz != null; clazz = clazz.getSuperclass()) {
            types.add(clazz);
            types.addAll(Arrays.asList(clazz.getInterfaces()));
        }
        return types;
    }

    private void registerContainerFactory(Archive<?> archive, Class<?> clazz) {
        ((JavaArchive)((JavaArchive)archive.as(JavaArchive.class)).addAsServiceProvider("org.wildfly.swarm.ContainerFactory", new String[]{clazz.getName()})).addClass(clazz);
        ((JARArchive)archive.as(JARArchive.class)).addModule("org.wildfly.swarm.container");
        ((JARArchive)archive.as(JARArchive.class)).addModule("org.wildfly.swarm.configuration");
    }

    @Override
    public void stop() throws Exception {
        this.process.stop();
    }

    private String ga(MavenCoordinate coord) {
        return String.format("%s:%s", coord.getGroupId(), coord.getArtifactId());
    }

    private String gav(MavenCoordinate coord) {
        return this.gav(coord.getGroupId(), coord.getArtifactId(), coord.getVersion());
    }

    private String gav(String group, String artifact, String version) {
        return String.format("%s:%s:%s", group, artifact, version);
    }

    private List<String> getJavaVmArgumentsList() {
        if (this.javaVmArguments == null) {
            return Collections.emptyList();
        }
        ArrayList<String> args = new ArrayList<String>();
        StringTokenizer tokens = new StringTokenizer(this.javaVmArguments);
        while (tokens.hasMoreTokens()) {
            args.add(tokens.nextToken());
        }
        return args;
    }
}

