/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.arquillian.resources;

import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.jboss.arquillian.container.spi.Container;
import org.jboss.arquillian.container.test.impl.enricher.resource.OperatesOnDeploymentAwareProvider;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.test.api.ArquillianResource;

public class SwarmURLResourceProvider
extends OperatesOnDeploymentAwareProvider {
    @Inject
    Instance<Container> containerInstance;

    public boolean canProvide(Class<?> type) {
        return URL.class.isAssignableFrom(type);
    }

    public Object doLookup(ArquillianResource resource, Annotation ... __) {
        String contextPath;
        String portOffset;
        String host;
        Container container = (Container)this.containerInstance.get();
        String javaVmArguments = null;
        String portDefinedInProperties = null;
        String offsetDefinedInProperties = null;
        if (container != null) {
            javaVmArguments = (String)container.getContainerConfiguration().getContainerProperties().get("javaVmArguments");
        }
        if (javaVmArguments != null && (javaVmArguments.contains("swarm.http.port") || javaVmArguments.contains("swarm.port.offset"))) {
            String[] properties = javaVmArguments.split("=| ");
            if (properties.length % 2 != 0) {
                throw new IllegalArgumentException("Cannot parse java VM arguments " + javaVmArguments);
            }
            for (int i = 0; i < properties.length; ++i) {
                if (properties[i].contains("swarm.http.port")) {
                    portDefinedInProperties = properties[i + 1];
                }
                if (!properties[i].contains("swarm.port.offset")) continue;
                offsetDefinedInProperties = properties[i + 1];
            }
        }
        if ((host = System.getProperty("swarm.bind.address")) == null || host.equals("0.0.0.0")) {
            host = "localhost";
        }
        int port = 8080;
        String portString = portDefinedInProperties != null ? portDefinedInProperties : System.getProperty("swarm.http.port");
        String string = portOffset = offsetDefinedInProperties != null ? offsetDefinedInProperties : System.getProperty("swarm.port.offset");
        if (portString != null) {
            port = Integer.parseInt(portString);
        }
        if (portOffset != null) {
            port += Integer.parseInt(portOffset);
        }
        if ((contextPath = System.getProperty("swarm.context.path")) == null) {
            contextPath = "/";
        }
        try {
            return new URI("http", null, host, port, contextPath, null, null).toURL();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

