/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.arquillian.adapter;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.StringTokenizer;
import org.jboss.shrinkwrap.api.Archive;
import org.wildfly.swarm.Swarm;
import org.wildfly.swarm.arquillian.CreateSwarm;
import org.wildfly.swarm.arquillian.adapter.SimpleContainer;
import org.wildfly.swarm.arquillian.daemon.DaemonServiceActivator;
import org.wildfly.swarm.msc.ServiceActivatorArchive;
import org.wildfly.swarm.spi.api.JARArchive;

public class InVMSimpleContainer
implements SimpleContainer {
    private final Class<?> testClass;
    private Swarm swarm;
    private String javaVmArguments;

    public InVMSimpleContainer(Class<?> testClass) {
        this.testClass = testClass;
    }

    @Override
    public InVMSimpleContainer setJavaVmArguments(String javaVmArguments) {
        this.javaVmArguments = javaVmArguments;
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void start(Archive<?> archive) throws Exception {
        ((JARArchive)((ServiceActivatorArchive)archive.as(ServiceActivatorArchive.class)).addServiceActivator(DaemonServiceActivator.class).as(JARArchive.class)).addModule("org.wildfly.swarm.arquillian.daemon");
        System.setProperty("swarm.app.artifact", archive.getName());
        Method swarmMethod = this.getAnnotatedMethodWithAnnotation(this.testClass, CreateSwarm.class);
        if (swarmMethod != null) {
            if (!Modifier.isStatic(swarmMethod.getModifiers())) throw new IllegalArgumentException(String.format("Method annotated with %s is %s but it is not static", CreateSwarm.class.getSimpleName(), swarmMethod));
            Object swarm = swarmMethod.invoke(null, new Object[0]);
            if (!(swarm instanceof Swarm)) throw new IllegalArgumentException(String.format("Method annotated with %s does not return an instance of %s", CreateSwarm.class.getSimpleName(), Swarm.class.getSimpleName()));
            this.swarm = (Swarm)swarm;
        } else {
            this.swarm = new Swarm();
        }
        this.handleJavaVmArguments();
        this.swarm.start().deploy(archive);
    }

    private void handleJavaVmArguments() {
        if (this.javaVmArguments == null) {
            return;
        }
        StringTokenizer tokens = new StringTokenizer(this.javaVmArguments);
        while (tokens.hasMoreTokens()) {
            String each = tokens.nextToken();
            if (!each.startsWith("-D")) {
                System.err.println("ignoring non-property Java VM argument for InVM test: " + each);
                continue;
            }
            int equalLoc = (each = each.substring(2)).indexOf("=");
            if (equalLoc < 0) {
                System.setProperty(each, "true");
                continue;
            }
            String key = each.substring(0, equalLoc);
            String value = each.substring(equalLoc + 1);
            System.setProperty(key, value);
        }
    }

    @Override
    public void stop() throws Exception {
        if (this.swarm != null) {
            this.swarm.stop();
        }
    }
}

