/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.batch.jberet;

import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.wildfly.common.cpu.ProcessorInfo;
import org.wildfly.swarm.config.BatchJBeret;
import org.wildfly.swarm.config.batch.jberet.InMemoryJobRepository;
import org.wildfly.swarm.config.batch.jberet.JDBCJobRepository;
import org.wildfly.swarm.config.batch.jberet.ThreadPool;
import org.wildfly.swarm.container.Fraction;
import org.wildfly.swarm.datasources.DatasourcesFraction;

public class BatchFraction
extends BatchJBeret<BatchFraction>
implements Fraction {
    public static final String DEFAULT_JOB_REPOSITORY_NAME = "in-memory";
    public static final String DEFAULT_THREAD_POOL_NAME = "batch";

    public static BatchFraction createDefaultFraction() {
        BatchFraction fraction = new BatchFraction();
        InMemoryJobRepository jobRepository = new InMemoryJobRepository(DEFAULT_JOB_REPOSITORY_NAME);
        ((BatchFraction)fraction.inMemoryJobRepository(jobRepository)).defaultJobRepository(jobRepository.getKey());
        ThreadPool threadPool = new ThreadPool(DEFAULT_THREAD_POOL_NAME);
        threadPool.maxThreads(Integer.valueOf(ProcessorInfo.availableProcessors())).keepaliveTime("time", (Object)"30").keepaliveTime("unit", (Object)"seconds");
        ((BatchFraction)fraction.threadPool(threadPool)).defaultThreadPool(threadPool.getKey());
        return fraction;
    }

    public BatchFraction defaultJobRepository(InMemoryJobRepository<?> jobRepository) {
        return (BatchFraction)this.defaultJobRepository(jobRepository.getKey());
    }

    public BatchFraction defaultJobRepository(JDBCJobRepository<?> jobRepository) {
        return (BatchFraction)this.defaultJobRepository(jobRepository.getKey());
    }

    public BatchFraction defaultJobRepository(DatasourcesFraction datasource) {
        return this.defaultJobRepository(datasource.getKey(), datasource);
    }

    public BatchFraction defaultJobRepository(String name, DatasourcesFraction datasource) {
        this.jdbcJobRepository(name, datasource);
        return (BatchFraction)this.defaultJobRepository(name);
    }

    public BatchFraction jdbcJobRepository(DatasourcesFraction datasource) {
        return this.jdbcJobRepository(datasource.getKey(), datasource);
    }

    public BatchFraction jdbcJobRepository(String name, DatasourcesFraction datasource) {
        return (BatchFraction)this.jdbcJobRepository(new JDBCJobRepository(name).dataSource(datasource.getKey()));
    }

    public BatchFraction defaultThreadPool(int maxThreads, int keepAliveTime, TimeUnit keepAliveUnits) {
        return this.defaultThreadPool(DEFAULT_THREAD_POOL_NAME, maxThreads, keepAliveTime, keepAliveUnits);
    }

    public BatchFraction defaultThreadPool(String name, int maxThreads, int keepAliveTime, TimeUnit keepAliveUnits) {
        this.threadPool(name, maxThreads, keepAliveTime, keepAliveUnits);
        return (BatchFraction)this.defaultThreadPool(name);
    }

    public BatchFraction threadPool(int maxThreads, int keepAliveTime, TimeUnit keepAliveUnits) {
        return this.threadPool(DEFAULT_THREAD_POOL_NAME, maxThreads, keepAliveTime, keepAliveUnits);
    }

    public BatchFraction threadPool(String name, int maxThreads, int keepAliveTime, TimeUnit keepAliveUnits) {
        ThreadPool threadPool = new ThreadPool(name);
        threadPool.maxThreads(Integer.valueOf(maxThreads)).keepaliveTime("time", (Object)Integer.toBinaryString(keepAliveTime)).keepaliveTime("unit", (Object)keepAliveUnits.name().toLowerCase(Locale.ROOT));
        return (BatchFraction)this.threadPool(threadPool);
    }
}

