/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.batch.jberet;

import java.util.Locale;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.wildfly.common.cpu.ProcessorInfo;
import org.wildfly.swarm.config.BatchJBeret;
import org.wildfly.swarm.config.batch.jberet.InMemoryJobRepository;
import org.wildfly.swarm.config.batch.jberet.JDBCJobRepository;
import org.wildfly.swarm.config.batch.jberet.ThreadPool;
import org.wildfly.swarm.datasources.DatasourcesFraction;
import org.wildfly.swarm.spi.api.Fraction;
import org.wildfly.swarm.spi.api.annotations.MarshalDMR;
import org.wildfly.swarm.spi.api.annotations.WildFlyExtension;

@WildFlyExtension(module="org.wildfly.extension.batch.jberet")
@MarshalDMR
public class BatchFraction
extends BatchJBeret<BatchFraction>
implements Fraction<BatchFraction> {
    public static final String DEFAULT_JOB_REPOSITORY_NAME = "in-memory";
    public static final String DEFAULT_THREAD_POOL_NAME = "batch";

    @PostConstruct
    public void postConstruct() {
        this.applyDefaults();
    }

    public static BatchFraction createDefaultFraction() {
        return new BatchFraction().applyDefaults();
    }

    public BatchFraction applyDefaults() {
        InMemoryJobRepository jobRepository = new InMemoryJobRepository(DEFAULT_JOB_REPOSITORY_NAME);
        ThreadPool threadPool = new ThreadPool(DEFAULT_THREAD_POOL_NAME);
        threadPool.maxThreads(Integer.valueOf(ProcessorInfo.availableProcessors())).keepaliveTime("time", (Object)"30").keepaliveTime("unit", (Object)"seconds");
        return (BatchFraction)((BatchFraction)((BatchFraction)((BatchFraction)this.inMemoryJobRepository(jobRepository)).defaultJobRepository(jobRepository.getKey())).threadPool(threadPool)).defaultThreadPool(threadPool.getKey());
    }

    public BatchFraction defaultJobRepository(InMemoryJobRepository<?> jobRepository) {
        return (BatchFraction)this.defaultJobRepository(jobRepository.getKey());
    }

    public BatchFraction defaultJobRepository(JDBCJobRepository<?> jobRepository) {
        return (BatchFraction)this.defaultJobRepository(jobRepository.getKey());
    }

    public BatchFraction defaultJobRepository(DatasourcesFraction datasource) {
        return this.defaultJobRepository(datasource.getKey(), datasource);
    }

    public BatchFraction defaultJobRepository(String name, DatasourcesFraction datasource) {
        this.jdbcJobRepository(name, datasource);
        return (BatchFraction)this.defaultJobRepository(name);
    }

    public BatchFraction jdbcJobRepository(DatasourcesFraction datasource) {
        return this.jdbcJobRepository(datasource.getKey(), datasource);
    }

    public BatchFraction jdbcJobRepository(String name, DatasourcesFraction datasource) {
        return (BatchFraction)this.jdbcJobRepository(new JDBCJobRepository(name).dataSource(datasource.getKey()));
    }

    public BatchFraction defaultThreadPool(int maxThreads, int keepAliveTime, TimeUnit keepAliveUnits) {
        return this.defaultThreadPool(DEFAULT_THREAD_POOL_NAME, maxThreads, keepAliveTime, keepAliveUnits);
    }

    public BatchFraction defaultThreadPool(String name, int maxThreads, int keepAliveTime, TimeUnit keepAliveUnits) {
        this.threadPool(name, maxThreads, keepAliveTime, keepAliveUnits);
        return (BatchFraction)this.defaultThreadPool(name);
    }

    public BatchFraction threadPool(int maxThreads, int keepAliveTime, TimeUnit keepAliveUnits) {
        return this.threadPool(DEFAULT_THREAD_POOL_NAME, maxThreads, keepAliveTime, keepAliveUnits);
    }

    public BatchFraction threadPool(String name, int maxThreads, int keepAliveTime, TimeUnit keepAliveUnits) {
        ThreadPool threadPool = new ThreadPool(name);
        threadPool.maxThreads(Integer.valueOf(maxThreads)).keepaliveTime("time", (Object)Integer.toBinaryString(keepAliveTime)).keepaliveTime("unit", (Object)keepAliveUnits.name().toLowerCase(Locale.ROOT));
        return (BatchFraction)this.threadPool(threadPool);
    }
}

