/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mqtt;

import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.mqtt.MQTTConfiguration;
import org.apache.camel.component.mqtt.MQTTEndpoint;
import org.apache.camel.impl.UriEndpointComponent;
import org.apache.camel.spi.Metadata;

public class MQTTComponent
extends UriEndpointComponent {
    private String host;
    @Metadata(label="security", secret=true)
    private String userName;
    @Metadata(label="security", secret=true)
    private String password;

    public MQTTComponent() {
        super(MQTTEndpoint.class);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        MQTTConfiguration configuration = new MQTTConfiguration();
        if (this.host != null) {
            configuration.setHost(this.host);
        }
        if (this.userName != null) {
            configuration.setUserName(this.userName);
        }
        if (this.password != null) {
            configuration.setPassword(this.password);
        }
        this.setProperties((Object)configuration, parameters);
        MQTTEndpoint endpoint = new MQTTEndpoint(uri, this, configuration);
        endpoint.setName(remaining);
        return endpoint;
    }

    public boolean useRawUri() {
        return true;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

