/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index.engine;

import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.index.OIndexAbstractCursor;
import com.orientechnologies.orient.core.index.OIndexCursor;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexEngine;
import com.orientechnologies.orient.core.index.OIndexKeyCursor;
import com.orientechnologies.orient.core.index.sbtree.local.OSBTree;
import com.orientechnologies.orient.core.iterator.OEmptyIterator;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class OSBTreeIndexEngine
implements OIndexEngine {
    public static final int VERSION = 1;
    public static final String DATA_FILE_EXTENSION = ".sbt";
    public static final String NULL_BUCKET_FILE_EXTENSION = ".nbt";
    private final OSBTree<Object, Object> sbTree;
    private int version;
    private final String name;

    public OSBTreeIndexEngine(String name, Boolean durableInNonTxMode, OAbstractPaginatedStorage storage, int version) {
        this.name = name;
        boolean durableInNonTx = durableInNonTxMode == null ? OGlobalConfiguration.INDEX_DURABLE_IN_NON_TX_MODE.getValueAsBoolean() : durableInNonTxMode.booleanValue();
        this.version = version;
        this.sbTree = new OSBTree(name, DATA_FILE_EXTENSION, durableInNonTx, NULL_BUCKET_FILE_EXTENSION, storage);
    }

    @Override
    public void init(String indexName, String indexType, OIndexDefinition indexDefinition, boolean isAutomatic, ODocument metadata) {
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void flush() {
    }

    @Override
    public void create(OBinarySerializer valueSerializer, boolean isAutomatic, OType[] keyTypes, boolean nullPointerSupport, OBinarySerializer keySerializer, int keySize, Set<String> clustersToIndex, Map<String, String> engineProperties, ODocument metadata) {
        this.sbTree.create(keySerializer, valueSerializer, keyTypes, keySize, nullPointerSupport);
    }

    @Override
    public void delete() {
        this.sbTree.delete();
    }

    @Override
    public void deleteWithoutLoad(String indexName) {
        this.sbTree.deleteWithoutLoad(indexName);
    }

    @Override
    public void load(String indexName, OBinarySerializer valueSerializer, boolean isAutomatic, OBinarySerializer keySerializer, OType[] keyTypes, boolean nullPointerSupport, int keySize, Map<String, String> engineProperties) {
        this.sbTree.load(indexName, keySerializer, valueSerializer, keyTypes, keySize, nullPointerSupport);
    }

    @Override
    public boolean contains(Object key) {
        return this.sbTree.get(key) != null;
    }

    @Override
    public boolean remove(Object key) {
        return this.sbTree.remove(key) != null;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public void clear() {
        this.sbTree.clear();
    }

    @Override
    public void close() {
        this.sbTree.close();
    }

    @Override
    public Object get(Object key) {
        return this.sbTree.get(key);
    }

    @Override
    public OIndexCursor cursor(OIndexEngine.ValuesTransformer valuesTransformer) {
        Object firstKey = this.sbTree.firstKey();
        if (firstKey == null) {
            return new NullCursor();
        }
        return new OSBTreeIndexCursor(this.sbTree.iterateEntriesMajor(firstKey, true, true), valuesTransformer);
    }

    @Override
    public OIndexCursor descCursor(OIndexEngine.ValuesTransformer valuesTransformer) {
        Object lastKey = this.sbTree.lastKey();
        if (lastKey == null) {
            return new NullCursor();
        }
        return new OSBTreeIndexCursor(this.sbTree.iterateEntriesMinor(lastKey, true, false), valuesTransformer);
    }

    @Override
    public OIndexKeyCursor keyCursor() {
        return new OIndexKeyCursor(){
            private final OSBTree.OSBTreeKeyCursor<Object> sbTreeKeyCursor;
            {
                this.sbTreeKeyCursor = OSBTreeIndexEngine.this.sbTree.keyCursor();
            }

            @Override
            public Object next(int prefetchSize) {
                return this.sbTreeKeyCursor.next(prefetchSize);
            }
        };
    }

    @Override
    public void put(Object key, Object value) {
        this.sbTree.put(key, value);
    }

    @Override
    public Object getFirstKey() {
        return this.sbTree.firstKey();
    }

    @Override
    public Object getLastKey() {
        return this.sbTree.lastKey();
    }

    @Override
    public OIndexCursor iterateEntriesBetween(Object rangeFrom, boolean fromInclusive, Object rangeTo, boolean toInclusive, boolean ascSortOrder, OIndexEngine.ValuesTransformer transformer) {
        return new OSBTreeIndexCursor(this.sbTree.iterateEntriesBetween(rangeFrom, fromInclusive, rangeTo, toInclusive, ascSortOrder), transformer);
    }

    @Override
    public OIndexCursor iterateEntriesMajor(Object fromKey, boolean isInclusive, boolean ascSortOrder, OIndexEngine.ValuesTransformer transformer) {
        return new OSBTreeIndexCursor(this.sbTree.iterateEntriesMajor(fromKey, isInclusive, ascSortOrder), transformer);
    }

    @Override
    public OIndexCursor iterateEntriesMinor(Object toKey, boolean isInclusive, boolean ascSortOrder, OIndexEngine.ValuesTransformer transformer) {
        return new OSBTreeIndexCursor(this.sbTree.iterateEntriesMinor(toKey, isInclusive, ascSortOrder), transformer);
    }

    @Override
    public long size(OIndexEngine.ValuesTransformer transformer) {
        if (transformer == null) {
            return this.sbTree.size();
        }
        Object firstKey = this.sbTree.firstKey();
        Object lastKey = this.sbTree.lastKey();
        if (firstKey != null && lastKey != null) {
            int counter = 0;
            OSBTree.OSBTreeCursor<Object, Object> cursor = this.sbTree.iterateEntriesBetween(firstKey, true, lastKey, true, true);
            Map.Entry<Object, Object> entry = cursor.next(-1);
            while (entry != null) {
                counter += transformer.transformFromValue(entry.getValue()).size();
                entry = cursor.next(-1);
            }
            return counter;
        }
        return 0L;
    }

    @Override
    public boolean hasRangeQuerySupport() {
        return true;
    }

    @Override
    public boolean acquireAtomicExclusiveLock(Object key) {
        this.sbTree.acquireAtomicExclusiveLock();
        return true;
    }

    @Override
    public String getIndexNameByKey(Object key) {
        return this.name;
    }

    private static class NullCursor
    extends OIndexAbstractCursor {
        private NullCursor() {
        }

        @Override
        public Map.Entry<Object, OIdentifiable> nextEntry() {
            return null;
        }
    }

    private static final class OSBTreeIndexCursor
    extends OIndexAbstractCursor {
        private final OSBTree.OSBTreeCursor<Object, Object> treeCursor;
        private final OIndexEngine.ValuesTransformer valuesTransformer;
        private Iterator<OIdentifiable> currentIterator = OEmptyIterator.IDENTIFIABLE_INSTANCE;
        private Object currentKey = null;

        private OSBTreeIndexCursor(OSBTree.OSBTreeCursor<Object, Object> treeCursor, OIndexEngine.ValuesTransformer valuesTransformer) {
            this.treeCursor = treeCursor;
            this.valuesTransformer = valuesTransformer;
        }

        @Override
        public Map.Entry<Object, OIdentifiable> nextEntry() {
            if (this.valuesTransformer == null) {
                Map.Entry<Object, Object> entry = this.treeCursor.next(this.getPrefetchSize());
                return entry;
            }
            if (this.currentIterator == null) {
                return null;
            }
            while (!this.currentIterator.hasNext()) {
                Map.Entry<Object, Object> p = this.treeCursor.next(this.getPrefetchSize());
                Map.Entry<Object, Object> entry = p;
                if (entry == null) {
                    this.currentIterator = null;
                    return null;
                }
                this.currentKey = entry.getKey();
                this.currentIterator = this.valuesTransformer.transformFromValue(entry.getValue()).iterator();
            }
            final OIdentifiable value = this.currentIterator.next();
            return new Map.Entry<Object, OIdentifiable>(){

                @Override
                public Object getKey() {
                    return OSBTreeIndexCursor.this.currentKey;
                }

                @Override
                public OIdentifiable getValue() {
                    return value;
                }

                @Override
                public OIdentifiable setValue(OIdentifiable value2) {
                    throw new UnsupportedOperationException("setValue");
                }
            };
        }
    }
}

