/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mllp.impl;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Hl7Util {
    static final Logger LOG = LoggerFactory.getLogger(Hl7Util.class);

    private Hl7Util() {
    }

    public static String generateInvalidPayloadExceptionMessage(byte[] hl7Bytes) {
        if (hl7Bytes == null) {
            return "HL7 payload is null";
        }
        return Hl7Util.generateInvalidPayloadExceptionMessage(hl7Bytes, hl7Bytes.length);
    }

    public static String generateInvalidPayloadExceptionMessage(byte[] hl7Bytes, int length) {
        if (hl7Bytes == null) {
            return "HL7 payload is null";
        }
        if (hl7Bytes.length <= 0) {
            return "HL7 payload is empty";
        }
        if (length > hl7Bytes.length) {
            LOG.warn("The length specified for the HL7 payload array <{}> is greater than the actual length of the array <{}> - only validating {} bytes", new Object[]{length, hl7Bytes.length, length});
        }
        if (hl7Bytes.length < 3 || hl7Bytes[0] != 77 || hl7Bytes[1] != 83 || hl7Bytes[2] != 72) {
            return String.format("The first segment of the HL7 payload {%s} is not an MSH segment", new String(hl7Bytes, 0, Math.min(3, hl7Bytes.length)));
        }
        int validationLength = Math.min(length, hl7Bytes.length);
        if (hl7Bytes[validationLength - 2] != 13 || hl7Bytes[validationLength - 1] != 10) {
            String format = "The HL7 payload terminating bytes [%#x, %#x] are incorrect - expected [%#x, %#x]  {ASCII [<CR>, <LF>]}";
            return String.format(format, hl7Bytes[validationLength - 2], hl7Bytes[validationLength - 1], (byte)13, (byte)10);
        }
        for (int i = 0; i < validationLength; ++i) {
            switch (hl7Bytes[i]) {
                case 11: {
                    return String.format("HL7 payload contains an embedded START_OF_BLOCK {%#x, ASCII <VT>} at index %d", hl7Bytes[i], i);
                }
                case 28: {
                    return String.format("HL7 payload contains an embedded END_OF_BLOCK {%#x, ASCII <FS>} at index %d", hl7Bytes[i], i);
                }
            }
        }
        return null;
    }
}

