/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.undertow.descriptors;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jboss.shrinkwrap.api.asset.NamedAsset;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.javaee7.ListenerType;
import org.jboss.shrinkwrap.descriptor.api.javaee7.ParamValueType;
import org.jboss.shrinkwrap.descriptor.api.webapp31.WebAppDescriptor;
import org.jboss.shrinkwrap.descriptor.api.webcommon31.LoginConfigType;
import org.jboss.shrinkwrap.descriptor.api.webcommon31.SecurityConstraintType;
import org.jboss.shrinkwrap.descriptor.api.webcommon31.ServletType;
import org.wildfly.swarm.spi.api.ClassLoading;
import org.wildfly.swarm.undertow.descriptors.SecurityConstraint;
import org.wildfly.swarm.undertow.descriptors.Servlet;

public class WebXmlAsset
implements NamedAsset {
    public static final String NAME = "WEB-INF/web.xml";
    private final WebAppDescriptor descriptor;
    private List<SecurityConstraint> constraints = new ArrayList<SecurityConstraint>();
    private List<Servlet> servlets = new ArrayList<Servlet>();

    public WebXmlAsset() {
        this.descriptor = (WebAppDescriptor)ClassLoading.withTCCL((ClassLoader)Descriptors.class.getClassLoader(), () -> (WebAppDescriptor)Descriptors.create(WebAppDescriptor.class));
    }

    public WebXmlAsset(InputStream fromStream) {
        this.descriptor = (WebAppDescriptor)ClassLoading.withTCCL((ClassLoader)Descriptors.class.getClassLoader(), () -> (WebAppDescriptor)Descriptors.importAs(WebAppDescriptor.class).fromStream(fromStream));
    }

    public void setContextParam(String name, String ... values) {
        this.descriptor.createContextParam().paramName(name).paramValue(this.convert(values));
    }

    public String getContextParam(String name) {
        if (name == null || name.length() == 0) {
            return null;
        }
        Optional<ParamValueType> paramValue = this.descriptor.getAllContextParam().stream().filter(p -> p.getParamName().equals(name)).findFirst();
        return paramValue.isPresent() ? paramValue.get().getParamValue() : null;
    }

    public Servlet addServlet(String servletName, String servletClass) {
        Servlet servlet = new Servlet(servletName, servletClass);
        this.servlets.add(servlet);
        return servlet;
    }

    public Servlet getServlet(String servletClass) {
        ServletType descriptorServlet = this.descriptor.getAllServlet().stream().filter(s -> s.getServletClass().equals(servletClass)).findFirst().get();
        return this.convert((ServletType<WebAppDescriptor>)descriptorServlet);
    }

    public void setLoginConfig(String authMethod, String realmName) {
        this.descriptor.getOrCreateLoginConfig().authMethod(authMethod).realmName(realmName);
    }

    public void setFormLoginConfig(String realmName, String loginPage, String errorPage) {
        this.descriptor.getOrCreateLoginConfig().authMethod("FORM").realmName(realmName).getOrCreateFormLoginConfig().formLoginPage(loginPage).formErrorPage(errorPage);
    }

    public String getLoginRealm(String authMethod) {
        if (authMethod == null || authMethod.length() == 0) {
            return null;
        }
        Optional<LoginConfigType> loginConfig = this.descriptor.getAllLoginConfig().stream().filter(l -> l.getAuthMethod().equals(authMethod)).findFirst();
        return loginConfig.isPresent() ? loginConfig.get().getRealmName() : null;
    }

    public void addListener(String listener) {
        this.descriptor.createListener().listenerClass(listener);
    }

    public List<String> allListenersClasses() {
        return this.descriptor.getAllListener().stream().map(ListenerType::getListenerClass).collect(Collectors.toList());
    }

    public SecurityConstraint protect() {
        SecurityConstraint constraint = new SecurityConstraint();
        this.constraints.add(constraint);
        return constraint;
    }

    public SecurityConstraint protect(String urlPattern) {
        SecurityConstraint constraint = new SecurityConstraint(urlPattern);
        this.constraints.add(constraint);
        return constraint;
    }

    public List<SecurityConstraint> allConstraints() {
        return this.constraints;
    }

    public List<String> getServletMapping(String servletName) {
        return this.descriptor.getAllServletMapping().stream().filter(mapping -> mapping.getServletName().equals(servletName)).findFirst().map(m -> m.getAllUrlPattern()).orElse(Collections.emptyList());
    }

    public InputStream openStream() {
        HashSet<String> allRoles = new HashSet<String>();
        for (SecurityConstraint securityConstraint : this.constraints) {
            SecurityConstraintType sc = (SecurityConstraintType)this.descriptor.createSecurityConstraint().createWebResourceCollection().urlPattern(new String[]{securityConstraint.urlPattern()}).httpMethod(securityConstraint.methods().toArray(new String[securityConstraint.methods().size()])).up();
            if (!securityConstraint.isPermitAll()) {
                sc.getOrCreateAuthConstraint().roleName(securityConstraint.roles().toArray(new String[securityConstraint.roles().size()])).up();
            }
            allRoles.addAll(securityConstraint.roles());
        }
        for (String string : allRoles) {
            this.descriptor.getOrCreateSecurityRole().roleName(string);
        }
        for (Servlet servlet : this.servlets) {
            ServletType servlet2 = this.descriptor.createServlet().servletName(servlet.servletName()).servletClass(servlet.servletClass()).displayName(new String[]{servlet.displayName()}).enabled(Boolean.valueOf(servlet.enabled()));
            if (servlet.asyncSupported() != null) {
                servlet2.asyncSupported(servlet.asyncSupported());
            }
            if (servlet.loadOnStartup() != null) {
                servlet2.loadOnStartup(servlet.loadOnStartup());
            }
            for (Map.Entry<String, String> init : servlet.initParams().entrySet()) {
                servlet2.createInitParam().paramName(init.getKey()).paramValue(init.getValue());
            }
            if (servlet.urlPatterns().size() <= 0) continue;
            this.descriptor.createServletMapping().servletName(servlet.servletName()).urlPattern((String[])servlet.urlPatterns().stream().toArray(String[]::new));
        }
        return new ByteArrayInputStream(this.descriptor.exportAsString().getBytes());
    }

    public String getName() {
        return NAME;
    }

    private String convert(String ... values) {
        StringBuilder builder = new StringBuilder();
        boolean addedFirst = false;
        for (String value : values) {
            if (addedFirst) {
                builder.append(',');
            }
            builder.append(value);
            addedFirst = true;
        }
        return builder.toString();
    }

    private Servlet convert(ServletType<WebAppDescriptor> descriptorServlet) {
        List descriptions;
        Servlet servlet = new Servlet(descriptorServlet.getServletName(), descriptorServlet.getServletClass());
        List dispNames = descriptorServlet.getAllDisplayName();
        if (dispNames.size() > 0) {
            servlet.withDisplayName((String)dispNames.get(0));
        }
        if ((descriptions = descriptorServlet.getAllDescription()).size() > 0) {
            servlet.withDescription((String)descriptions.get(0));
        }
        servlet.withEnabled(descriptorServlet.isEnabled());
        servlet.withAsyncSupported(descriptorServlet.isAsyncSupported());
        servlet.withLoadOnStartup(descriptorServlet.getLoadOnStartup());
        servlet.withInitParams(descriptorServlet.getAllInitParam().stream().collect(Collectors.toMap(ParamValueType::getParamName, ParamValueType::getParamValue)));
        servlet.withUrlPatterns(this.descriptor.getAllServletMapping().stream().filter(mapping -> mapping.getServletName().equals(servlet.servletName())).findFirst().get().getAllUrlPattern());
        return servlet;
    }
}

