/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.reactive.streams.util;

import org.apache.camel.CamelContext;
import org.apache.camel.component.reactive.streams.api.CamelReactiveStreams;
import org.apache.camel.component.reactive.streams.api.CamelReactiveStreamsService;
import org.apache.camel.spi.FactoryFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReactiveStreamsServiceCreationHelper {
    private static final Logger LOG = LoggerFactory.getLogger(CamelReactiveStreams.class);

    private ReactiveStreamsServiceCreationHelper() {
    }

    public static CamelReactiveStreamsService createNewReactiveStreamsService(CamelContext context, String name) {
        if (name == null) {
            name = "default-service";
        }
        String path = "META-INF/services/org/apache/camel/reactive-streams/";
        try {
            FactoryFinder finder = context.getFactoryFinder(path);
            LOG.trace("Using FactoryFinder: {}", (Object)finder);
            Class serviceClass = finder.findClass(name);
            return (CamelReactiveStreamsService)serviceClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Class referenced in '" + path + name + "' not found", e);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to create the reactive stream service defined in '" + path + name + "'", e);
        }
    }
}

