/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.nats;

import io.nats.client.Connection;
import io.nats.client.ConnectionFactory;
import io.nats.client.Message;
import io.nats.client.MessageHandler;
import io.nats.client.Subscription;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.SSLContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.nats.NatsConfiguration;
import org.apache.camel.component.nats.NatsEndpoint;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NatsConsumer
extends DefaultConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(NatsConsumer.class);
    private final Processor processor;
    private ExecutorService executor;
    private Connection connection;
    private Subscription sid;
    private boolean subscribed;

    public NatsConsumer(NatsEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.processor = processor;
    }

    public NatsEndpoint getEndpoint() {
        return (NatsEndpoint)super.getEndpoint();
    }

    protected void doStart() throws Exception {
        super.doStart();
        LOG.debug("Starting Nats Consumer");
        this.executor = this.getEndpoint().createExecutor();
        LOG.debug("Getting Nats Connection");
        this.connection = this.getConnection();
        this.executor.submit(new NatsConsumingTask(this.connection, this.getEndpoint().getNatsConfiguration()));
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.getEndpoint().getNatsConfiguration().isFlushConnection()) {
            LOG.debug("Flushing Messages before stopping");
            this.connection.flush(this.getEndpoint().getNatsConfiguration().getFlushTimeout());
        }
        try {
            this.sid.unsubscribe();
        }
        catch (Exception e) {
            this.getExceptionHandler().handleException("Error during unsubscribing", (Throwable)e);
        }
        LOG.debug("Stopping Nats Consumer");
        if (this.executor != null) {
            if (this.getEndpoint() != null && this.getEndpoint().getCamelContext() != null) {
                this.getEndpoint().getCamelContext().getExecutorServiceManager().shutdownNow(this.executor);
            } else {
                this.executor.shutdownNow();
            }
        }
        this.executor = null;
        LOG.debug("Closing Nats Connection");
        if (!this.connection.isClosed()) {
            this.connection.close();
        }
    }

    private Connection getConnection() throws IOException, InterruptedException, TimeoutException, GeneralSecurityException {
        Properties prop = this.getEndpoint().getNatsConfiguration().createProperties();
        ConnectionFactory factory = new ConnectionFactory(prop);
        if (this.getEndpoint().getNatsConfiguration().getSslContextParameters() != null && this.getEndpoint().getNatsConfiguration().isSecure()) {
            SSLContext sslCtx = this.getEndpoint().getNatsConfiguration().getSslContextParameters().createSSLContext(this.getEndpoint().getCamelContext());
            factory.setSSLContext(sslCtx);
            if (this.getEndpoint().getNatsConfiguration().isTlsDebug()) {
                factory.setTlsDebug(this.getEndpoint().getNatsConfiguration().isTlsDebug());
            }
        }
        this.connection = factory.createConnection();
        return this.connection;
    }

    public boolean isSubscribed() {
        return this.subscribed;
    }

    public void setSubscribed(boolean subscribed) {
        this.subscribed = subscribed;
    }

    class NatsConsumingTask
    implements Runnable {
        private final Connection connection;
        private final NatsConfiguration configuration;

        NatsConsumingTask(Connection connection, NatsConfiguration configuration) {
            this.connection = connection;
            this.configuration = configuration;
        }

        @Override
        public void run() {
            try {
                if (ObjectHelper.isNotEmpty((Object)this.configuration.getQueueName())) {
                    NatsConsumer.this.sid = (Subscription)this.connection.subscribe(NatsConsumer.this.getEndpoint().getNatsConfiguration().getTopic(), NatsConsumer.this.getEndpoint().getNatsConfiguration().getQueueName(), new MessageHandler(){

                        public void onMessage(Message msg) {
                            LOG.debug("Received Message: {}", (Object)msg);
                            Exchange exchange = NatsConsumer.this.getEndpoint().createExchange();
                            exchange.getIn().setBody((Object)msg);
                            exchange.getIn().setHeader("CamelNatsMessageTimestamp", (Object)System.currentTimeMillis());
                            exchange.getIn().setHeader("CamelNatsSubscriptionId", (Object)NatsConsumer.this.sid);
                            try {
                                NatsConsumer.this.processor.process(exchange);
                            }
                            catch (Exception e) {
                                NatsConsumer.this.getExceptionHandler().handleException("Error during processing", exchange, (Throwable)e);
                            }
                        }
                    });
                    if (ObjectHelper.isNotEmpty((Object)NatsConsumer.this.getEndpoint().getNatsConfiguration().getMaxMessages())) {
                        NatsConsumer.this.sid.autoUnsubscribe(Integer.parseInt(NatsConsumer.this.getEndpoint().getNatsConfiguration().getMaxMessages()));
                    }
                    if (NatsConsumer.this.sid.isValid()) {
                        NatsConsumer.this.setSubscribed(true);
                    }
                } else {
                    NatsConsumer.this.sid = (Subscription)this.connection.subscribe(NatsConsumer.this.getEndpoint().getNatsConfiguration().getTopic(), new MessageHandler(){

                        public void onMessage(Message msg) {
                            LOG.debug("Received Message: {}", (Object)msg);
                            Exchange exchange = NatsConsumer.this.getEndpoint().createExchange();
                            exchange.getIn().setBody((Object)msg);
                            exchange.getIn().setHeader("CamelNatsMessageTimestamp", (Object)System.currentTimeMillis());
                            exchange.getIn().setHeader("CamelNatsSubscriptionId", (Object)NatsConsumer.this.sid);
                            try {
                                NatsConsumer.this.processor.process(exchange);
                            }
                            catch (Exception e) {
                                NatsConsumer.this.getExceptionHandler().handleException("Error during processing", exchange, (Throwable)e);
                            }
                        }
                    });
                    if (ObjectHelper.isNotEmpty((Object)NatsConsumer.this.getEndpoint().getNatsConfiguration().getMaxMessages())) {
                        NatsConsumer.this.sid.autoUnsubscribe(Integer.parseInt(NatsConsumer.this.getEndpoint().getNatsConfiguration().getMaxMessages()));
                    }
                    if (NatsConsumer.this.sid.isValid()) {
                        NatsConsumer.this.setSubscribed(true);
                    }
                }
            }
            catch (Throwable e) {
                NatsConsumer.this.getExceptionHandler().handleException("Error during processing", e);
            }
        }
    }
}

