/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.logging;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.wildfly.swarm.config.logging.Level;
import org.wildfly.swarm.config.runtime.Addresses;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Addresses(value={"/subsystem=logging/async-handler=*", "/subsystem=logging/logging-profile=*/async-handler=*"})
@ResourceType(value="async-handler")
public class AsyncHandler<T extends AsyncHandler<T>>
extends HashMap
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="If set to true the handler is enabled and functioning as normal, if set to false the handler is ignored when processing log messages.")
    private Boolean enabled;
    @AttributeDocumentation(value="A filter expression value to define a filter. Example for a filter that does not match a pattern: not(match(\"JBAS.*\"))")
    private String filterSpec;
    @AttributeDocumentation(value="The log level specifying which message levels will be logged by this handler. Message levels lower than this value will be discarded.")
    private Level level;
    @AttributeDocumentation(value="Specify what action to take when the overflowing.  The valid options are 'block' and 'discard'")
    private OverflowAction overflowAction;
    @AttributeDocumentation(value="The queue length to use before flushing writing")
    private Integer queueLength;
    @AttributeDocumentation(value="The Handlers associated with this async handler.")
    private List<String> subhandlers;

    public AsyncHandler(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="enabled")
    public Boolean enabled() {
        return this.enabled;
    }

    public T enabled(Boolean value) {
        Boolean oldValue = this.enabled;
        this.enabled = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("enabled", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="filter-spec")
    public String filterSpec() {
        return this.filterSpec;
    }

    public T filterSpec(String value) {
        String oldValue = this.filterSpec;
        this.filterSpec = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("filterSpec", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="level")
    public Level level() {
        return this.level;
    }

    public T level(Level value) {
        Level oldValue = this.level;
        this.level = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("level", (Object)oldValue, (Object)value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="overflow-action")
    public OverflowAction overflowAction() {
        return this.overflowAction;
    }

    public T overflowAction(OverflowAction value) {
        OverflowAction oldValue = this.overflowAction;
        this.overflowAction = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("overflowAction", (Object)oldValue, (Object)value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="queue-length")
    public Integer queueLength() {
        return this.queueLength;
    }

    public T queueLength(Integer value) {
        Integer oldValue = this.queueLength;
        this.queueLength = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("queueLength", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="subhandlers")
    public List<String> subhandlers() {
        return this.subhandlers;
    }

    public T subhandlers(List<String> value) {
        List<String> oldValue = this.subhandlers;
        this.subhandlers = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("subhandlers", oldValue, value);
        }
        return (T)this;
    }

    public T subhandler(String value) {
        if (this.subhandlers == null) {
            this.subhandlers = new ArrayList<String>();
        }
        this.subhandlers.add(value);
        return (T)this;
    }

    public T subhandlers(String ... args) {
        this.subhandlers(Arrays.stream(args).collect(Collectors.toList()));
        return (T)this;
    }

    public static enum OverflowAction {
        BLOCK("BLOCK"),
        DISCARD("DISCARD");

        private final String allowedValue;

        public String getAllowedValue() {
            return this.allowedValue;
        }

        private OverflowAction(String allowedValue) {
            this.allowedValue = allowedValue;
        }

        public String toString() {
            return this.allowedValue;
        }
    }
}

