/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.coap;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.coap.CoAPComponent;
import org.apache.camel.coap.CoAPConsumer;
import org.apache.camel.coap.CoAPProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.eclipse.californium.core.CoapServer;

@UriEndpoint(firstVersion="2.16.0", scheme="coap", title="CoAP", syntax="coap:uri", consumerClass=CoAPConsumer.class, label="iot")
public class CoAPEndpoint
extends DefaultEndpoint {
    @UriPath
    private URI uri;
    @UriParam(defaultValue="*")
    private String coapMethod = "*";
    private CoAPComponent component;

    public CoAPEndpoint(String uri, CoAPComponent component) {
        super(uri, (Component)component);
        try {
            this.uri = new URI(uri);
        }
        catch (URISyntaxException use) {
            this.uri = null;
        }
        this.component = component;
    }

    public void setCoapMethod(String m) {
        this.coapMethod = m;
    }

    public String getCoapMethod() {
        return this.coapMethod;
    }

    public Producer createProducer() throws Exception {
        return new CoAPProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return new CoAPConsumer(this, processor);
    }

    public boolean isSingleton() {
        return true;
    }

    public void setUri(URI u) {
        this.uri = u;
    }

    public URI getUri() {
        return this.uri;
    }

    public CoapServer getCoapServer() {
        return this.component.getServer(this.getUri().getPort());
    }
}

