/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.impl.controller;

import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.kie.server.api.model.KieServerInfo;
import org.kie.server.controller.api.KieServerController;
import org.kie.server.controller.api.model.KieServerSetup;
import org.kie.server.services.api.KieControllerNotConnectedException;
import org.kie.server.services.impl.ContainerManager;
import org.kie.server.services.impl.KieServerImpl;
import org.kie.server.services.impl.storage.KieServerState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControllerConnectRunnable
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(ControllerConnectRunnable.class);
    private volatile AtomicBoolean kieServerActive;
    private KieServerController kieController;
    private KieServerInfo kieServerInfo;
    private KieServerState currentState;
    private ContainerManager containerManager;
    private KieServerImpl kieServer;

    public ControllerConnectRunnable(AtomicBoolean kieServerActive, KieServerController kieController, KieServerInfo kieServerInfo, KieServerState currentState, ContainerManager containerManager, KieServerImpl kieServer) {
        this.kieServerActive = kieServerActive;
        this.kieController = kieController;
        this.kieServerInfo = kieServerInfo;
        this.currentState = currentState;
        this.containerManager = containerManager;
        this.kieServer = kieServer;
    }

    @Override
    public void run() {
        while (this.kieServerActive.get()) {
            try {
                logger.debug("Attempting to connect to one of the controllers...");
                KieServerSetup kieServerSetup = this.kieController.connect(this.kieServerInfo);
                logger.debug("Connected to controller and retrieved setup details {}", (Object)kieServerSetup);
                Set containers = kieServerSetup.getContainers();
                this.kieServer.addServerStatusMessage(this.kieServerInfo);
                this.containerManager.installContainers(this.kieServer, containers, this.currentState, kieServerSetup);
                break;
            }
            catch (KieControllerNotConnectedException e) {
                long waitTime = Long.parseLong(System.getProperty("org.kie.server.controller.connect", "10000"));
                logger.debug("Still cannot connect to any controllers, waiting for {} before next attempt", (Object)waitTime);
                try {
                    Thread.sleep(waitTime);
                }
                catch (InterruptedException e1) {
                    logger.warn("Controller connect thread got interrupted");
                }
            }
        }
        logger.info("Connected to controller, quiting connector thread");
    }
}

