package org.jboss.shrinkwrap.descriptor.api.jboss51; 

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
/**
 * This interface defines the contract for the <code> resource-managerType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public interface ResourceManagerType<T> extends Child<T> { 

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ResourceManagerType ElementName: xsd:string ElementType : description
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Creates for all String objects representing <code>description</code> elements, 
    * a new <code>description</code> element 
    * @param values list of <code>description</code> objects 
    * @return the current instance of <code>ResourceManagerType<T></code> 
    */
   public ResourceManagerType<T> description(String ... values);

   /**
    * Returns all <code>description</code> elements
    * @return list of <code>description</code> 
    */
   public List<String> getAllDescription();

   /**
    * Removes the <code>description</code> element 
    * @return the current instance of <code>ResourceManagerType<T></code> 
    */
   public ResourceManagerType<T> removeAllDescription();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ResourceManagerType ElementName: xsd:string ElementType : res-name
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>res-name</code> element
    * @param resName the value for the element <code>res-name</code> 
    * @return the current instance of <code>ResourceManagerType<T></code> 
    */
   public ResourceManagerType<T> resName(String resName);

   /**
    * Returns the <code>res-name</code> element
    * @return the node defined for the element <code>res-name</code> 
    */
   public String getResName();

   /**
    * Removes the <code>res-name</code> element 
    * @return the current instance of <code>ResourceManagerType<T></code> 
    */
   public ResourceManagerType<T> removeResName();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ResourceManagerType ElementName: xsd:string ElementType : res-jndi-name
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>res-jndi-name</code> element
    * @param resJndiName the value for the element <code>res-jndi-name</code> 
    * @return the current instance of <code>ResourceManagerType<T></code> 
    */
   public ResourceManagerType<T> resJndiName(String resJndiName);

   /**
    * Returns the <code>res-jndi-name</code> element
    * @return the node defined for the element <code>res-jndi-name</code> 
    */
   public String getResJndiName();

   /**
    * Removes the <code>res-jndi-name</code> element 
    * @return the current instance of <code>ResourceManagerType<T></code> 
    */
   public ResourceManagerType<T> removeResJndiName();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ResourceManagerType ElementName: xsd:string ElementType : res-url
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>res-url</code> element
    * @param resUrl the value for the element <code>res-url</code> 
    * @return the current instance of <code>ResourceManagerType<T></code> 
    */
   public ResourceManagerType<T> resUrl(String resUrl);

   /**
    * Returns the <code>res-url</code> element
    * @return the node defined for the element <code>res-url</code> 
    */
   public String getResUrl();

   /**
    * Removes the <code>res-url</code> element 
    * @return the current instance of <code>ResourceManagerType<T></code> 
    */
   public ResourceManagerType<T> removeResUrl();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ResourceManagerType ElementName: xsd:ID ElementType : id
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>id</code> attribute
    * @param id the value for the attribute <code>id</code> 
    * @return the current instance of <code>ResourceManagerType<T></code> 
    */
   public ResourceManagerType<T> id(String id);

   /**
    * Returns the <code>id</code> attribute
    * @return the value defined for the attribute <code>id</code> 
    */
   public String getId();

   /**
    * Removes the <code>id</code> attribute 
    * @return the current instance of <code>ResourceManagerType<T></code> 
    */
   public ResourceManagerType<T> removeId();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ResourceManagerType ElementName: xsd:string ElementType : res-class
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>res-class</code> attribute
    * @param resClass the value for the attribute <code>res-class</code> 
    * @return the current instance of <code>ResourceManagerType<T></code> 
    */
   public ResourceManagerType<T> resClass(String resClass);

   /**
    * Returns the <code>res-class</code> attribute
    * @return the value defined for the attribute <code>res-class</code> 
    */
   public String getResClass();

   /**
    * Removes the <code>res-class</code> attribute 
    * @return the current instance of <code>ResourceManagerType<T></code> 
    */
   public ResourceManagerType<T> removeResClass();
}
