package org.jboss.shrinkwrap.descriptor.api.jboss51; 

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.api.jboss51.ResourceManagerType;
/**
 * This interface defines the contract for the <code> resource-managersType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public interface ResourceManagersType<T> extends Child<T> { 

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ResourceManagersType ElementName: xsd:string ElementType : description
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Creates for all String objects representing <code>description</code> elements, 
    * a new <code>description</code> element 
    * @param values list of <code>description</code> objects 
    * @return the current instance of <code>ResourceManagersType<T></code> 
    */
   public ResourceManagersType<T> description(String ... values);

   /**
    * Returns all <code>description</code> elements
    * @return list of <code>description</code> 
    */
   public List<String> getAllDescription();

   /**
    * Removes the <code>description</code> element 
    * @return the current instance of <code>ResourceManagersType<T></code> 
    */
   public ResourceManagersType<T> removeAllDescription();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ResourceManagersType ElementName: jboss:resource-managerType ElementType : resource-manager
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>resource-manager</code> element will be created and returned.
    * Otherwise, the first existing <code>resource-manager</code> element will be returned.
    * @return the instance defined for the element <code>resource-manager</code> 
    */
   public ResourceManagerType<ResourceManagersType<T>> getOrCreateResourceManager();

   /**
    * Creates a new <code>resource-manager</code> element 
    * @return the new created instance of <code>ResourceManagerType<ResourceManagersType<T>></code> 
    */
   public ResourceManagerType<ResourceManagersType<T>> createResourceManager();

   /**
    * Returns all <code>resource-manager</code> elements
    * @return list of <code>resource-manager</code> 
    */
   public List<ResourceManagerType<ResourceManagersType<T>>> getAllResourceManager();

   /**
    * Removes all <code>resource-manager</code> elements 
    * @return the current instance of <code>ResourceManagerType<ResourceManagersType<T>></code> 
    */
   public ResourceManagersType<T> removeAllResourceManager();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ResourceManagersType ElementName: xsd:ID ElementType : id
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>id</code> attribute
    * @param id the value for the attribute <code>id</code> 
    * @return the current instance of <code>ResourceManagersType<T></code> 
    */
   public ResourceManagersType<T> id(String id);

   /**
    * Returns the <code>id</code> attribute
    * @return the value defined for the attribute <code>id</code> 
    */
   public String getId();

   /**
    * Removes the <code>id</code> attribute 
    * @return the current instance of <code>ResourceManagersType<T></code> 
    */
   public ResourceManagersType<T> removeId();
}
