package org.jboss.shrinkwrap.descriptor.api.jbosscommon60; 

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.api.jbosscommon60.LoaderRepositoryConfigType;
/**
 * This interface defines the contract for the <code> loader-repositoryType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public interface LoaderRepositoryType<T> extends Child<T> { 

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: LoaderRepositoryType ElementName: text ElementType : loader-repositoryType
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the body text for the element <code>loader-repositoryType</code> 
    * @param loaderRepositoryType the value for the body text <code>loader-repositoryType</code> 
    * @return the current instance of <code>LoaderRepositoryType<T></code> 
    */
   public LoaderRepositoryType<T> text(String value);

   /**
    * Returns the body text of the element <code>loader-repositoryType</code> 
    * @return the value defined for the text <code>loader-repositoryType</code> 
    */
   public String getText();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: LoaderRepositoryType ElementName: jboss:loader-repository-configType ElementType : loader-repository-config
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>loader-repository-config</code> element will be created and returned.
    * Otherwise, the first existing <code>loader-repository-config</code> element will be returned.
    * @return the instance defined for the element <code>loader-repository-config</code> 
    */
   public LoaderRepositoryConfigType<LoaderRepositoryType<T>> getOrCreateLoaderRepositoryConfig();

   /**
    * Creates a new <code>loader-repository-config</code> element 
    * @return the new created instance of <code>LoaderRepositoryConfigType<LoaderRepositoryType<T>></code> 
    */
   public LoaderRepositoryConfigType<LoaderRepositoryType<T>> createLoaderRepositoryConfig();

   /**
    * Returns all <code>loader-repository-config</code> elements
    * @return list of <code>loader-repository-config</code> 
    */
   public List<LoaderRepositoryConfigType<LoaderRepositoryType<T>>> getAllLoaderRepositoryConfig();

   /**
    * Removes all <code>loader-repository-config</code> elements 
    * @return the current instance of <code>LoaderRepositoryConfigType<LoaderRepositoryType<T>></code> 
    */
   public LoaderRepositoryType<T> removeAllLoaderRepositoryConfig();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: LoaderRepositoryType ElementName: xsd:ID ElementType : id
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>id</code> attribute
    * @param id the value for the attribute <code>id</code> 
    * @return the current instance of <code>LoaderRepositoryType<T></code> 
    */
   public LoaderRepositoryType<T> id(String id);

   /**
    * Returns the <code>id</code> attribute
    * @return the value defined for the attribute <code>id</code> 
    */
   public String getId();

   /**
    * Removes the <code>id</code> attribute 
    * @return the current instance of <code>LoaderRepositoryType<T></code> 
    */
   public LoaderRepositoryType<T> removeId();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: LoaderRepositoryType ElementName: xsd:string ElementType : loaderRepositoryClass
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>loaderRepositoryClass</code> attribute
    * @param loaderRepositoryClass the value for the attribute <code>loaderRepositoryClass</code> 
    * @return the current instance of <code>LoaderRepositoryType<T></code> 
    */
   public LoaderRepositoryType<T> loaderRepositoryClass(String loaderRepositoryClass);

   /**
    * Returns the <code>loaderRepositoryClass</code> attribute
    * @return the value defined for the attribute <code>loaderRepositoryClass</code> 
    */
   public String getLoaderRepositoryClass();

   /**
    * Removes the <code>loaderRepositoryClass</code> attribute 
    * @return the current instance of <code>LoaderRepositoryType<T></code> 
    */
   public LoaderRepositoryType<T> removeLoaderRepositoryClass();
}
