package org.jboss.shrinkwrap.descriptor.api.jbossdeployment12; 

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment12.ModuleAliasType;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment12.FilterType;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment12.DependenciesType;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment12.ResourcesType;
/**
 * This interface defines the contract for the <code> moduleType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public interface ModuleType<T> extends Child<T> { 

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ModuleType ElementName: jboss:moduleAliasType ElementType : module-alias
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>module-alias</code> element with the given value will be created.
    * Otherwise, the existing <code>module-alias</code> element will be returned.
    * @return  a new or existing instance of <code>ModuleAliasType<ModuleType<T>></code> 
    */
   public ModuleAliasType<ModuleType<T>> getOrCreateModuleAlias();

   /**
    * Removes the <code>module-alias</code> element 
    * @return the current instance of <code>ModuleType<T></code> 
    */
   public ModuleType<T> removeModuleAlias();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ModuleType ElementName: jboss:filterType ElementType : exports
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>exports</code> element with the given value will be created.
    * Otherwise, the existing <code>exports</code> element will be returned.
    * @return  a new or existing instance of <code>FilterType<ModuleType<T>></code> 
    */
   public FilterType<ModuleType<T>> getOrCreateExports();

   /**
    * Removes the <code>exports</code> element 
    * @return the current instance of <code>ModuleType<T></code> 
    */
   public ModuleType<T> removeExports();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ModuleType ElementName: jboss:dependenciesType ElementType : dependencies
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>dependencies</code> element with the given value will be created.
    * Otherwise, the existing <code>dependencies</code> element will be returned.
    * @return  a new or existing instance of <code>DependenciesType<ModuleType<T>></code> 
    */
   public DependenciesType<ModuleType<T>> getOrCreateDependencies();

   /**
    * Removes the <code>dependencies</code> element 
    * @return the current instance of <code>ModuleType<T></code> 
    */
   public ModuleType<T> removeDependencies();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ModuleType ElementName: jboss:resourcesType ElementType : resources
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>resources</code> element with the given value will be created.
    * Otherwise, the existing <code>resources</code> element will be returned.
    * @return  a new or existing instance of <code>ResourcesType<ModuleType<T>></code> 
    */
   public ResourcesType<ModuleType<T>> getOrCreateResources();

   /**
    * Removes the <code>resources</code> element 
    * @return the current instance of <code>ModuleType<T></code> 
    */
   public ModuleType<T> removeResources();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ModuleType ElementName: xsd:string ElementType : name
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>name</code> attribute
    * @param name the value for the attribute <code>name</code> 
    * @return the current instance of <code>ModuleType<T></code> 
    */
   public ModuleType<T> name(String name);

   /**
    * Returns the <code>name</code> attribute
    * @return the value defined for the attribute <code>name</code> 
    */
   public String getName();

   /**
    * Removes the <code>name</code> attribute 
    * @return the current instance of <code>ModuleType<T></code> 
    */
   public ModuleType<T> removeName();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ModuleType ElementName: xsd:string ElementType : slot
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>slot</code> attribute
    * @param slot the value for the attribute <code>slot</code> 
    * @return the current instance of <code>ModuleType<T></code> 
    */
   public ModuleType<T> slot(String slot);

   /**
    * Returns the <code>slot</code> attribute
    * @return the value defined for the attribute <code>slot</code> 
    */
   public String getSlot();

   /**
    * Removes the <code>slot</code> attribute 
    * @return the current instance of <code>ModuleType<T></code> 
    */
   public ModuleType<T> removeSlot();
}
