package org.jboss.shrinkwrap.descriptor.api.wildflyfeaturepack11; 

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.api.wildflyfeaturepack11.FilterType;
/**
 * This interface defines the contract for the <code> copy-artifact-type </code> xsd type 
 * @author <a href="mailto:bmcwhirt@redhat.com">Bob McWhirter</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public interface CopyArtifactType<T> extends Child<T> { 

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: CopyArtifactType ElementName: wildfly:filter-type ElementType : filter
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>filter</code> element will be created and returned.
    * Otherwise, the first existing <code>filter</code> element will be returned.
    * @return the instance defined for the element <code>filter</code> 
    */
   public FilterType<CopyArtifactType<T>> getOrCreateFilter();

   /**
    * Creates a new <code>filter</code> element 
    * @return the new created instance of <code>FilterType<CopyArtifactType<T>></code> 
    */
   public FilterType<CopyArtifactType<T>> createFilter();

   /**
    * Returns all <code>filter</code> elements
    * @return list of <code>filter</code> 
    */
   public List<FilterType<CopyArtifactType<T>>> getAllFilter();

   /**
    * Removes all <code>filter</code> elements 
    * @return the current instance of <code>FilterType<CopyArtifactType<T>></code> 
    */
   public CopyArtifactType<T> removeAllFilter();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: CopyArtifactType ElementName: xsd:string ElementType : artifact
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>artifact</code> attribute
    * @param artifact the value for the attribute <code>artifact</code> 
    * @return the current instance of <code>CopyArtifactType<T></code> 
    */
   public CopyArtifactType<T> artifact(String artifact);

   /**
    * Returns the <code>artifact</code> attribute
    * @return the value defined for the attribute <code>artifact</code> 
    */
   public String getArtifact();

   /**
    * Removes the <code>artifact</code> attribute 
    * @return the current instance of <code>CopyArtifactType<T></code> 
    */
   public CopyArtifactType<T> removeArtifact();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: CopyArtifactType ElementName: xsd:string ElementType : to-location
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>to-location</code> attribute
    * @param toLocation the value for the attribute <code>to-location</code> 
    * @return the current instance of <code>CopyArtifactType<T></code> 
    */
   public CopyArtifactType<T> toLocation(String toLocation);

   /**
    * Returns the <code>to-location</code> attribute
    * @return the value defined for the attribute <code>to-location</code> 
    */
   public String getToLocation();

   /**
    * Removes the <code>to-location</code> attribute 
    * @return the current instance of <code>CopyArtifactType<T></code> 
    */
   public CopyArtifactType<T> removeToLocation();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: CopyArtifactType ElementName: xsd:boolean ElementType : extract
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>extract</code> attribute
    * @param extract the value for the attribute <code>extract</code> 
    * @return the current instance of <code>CopyArtifactType<T></code> 
    */
   public CopyArtifactType<T> extract(Boolean extract);

   /**
    * Returns the <code>extract</code> attribute
    * @return the value defined for the attribute <code>extract</code> 
    */
public Boolean isExtract();

   /**
    * Removes the <code>extract</code> attribute 
    * @return the current instance of <code>CopyArtifactType<T></code> 
    */
   public CopyArtifactType<T> removeExtract();
}
