package org.jboss.shrinkwrap.descriptor.api.wildflyfeaturepack11; 

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.api.wildflyfeaturepack11.FilePermissionType;
/**
 * This interface defines the contract for the <code> file-permissions-type </code> xsd type 
 * @author <a href="mailto:bmcwhirt@redhat.com">Bob McWhirter</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public interface FilePermissionsType<T> extends Child<T> { 

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: FilePermissionsType ElementName: wildfly:file-permission-type ElementType : permission
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>permission</code> element will be created and returned.
    * Otherwise, the first existing <code>permission</code> element will be returned.
    * @return the instance defined for the element <code>permission</code> 
    */
   public FilePermissionType<FilePermissionsType<T>> getOrCreatePermission();

   /**
    * Creates a new <code>permission</code> element 
    * @return the new created instance of <code>FilePermissionType<FilePermissionsType<T>></code> 
    */
   public FilePermissionType<FilePermissionsType<T>> createPermission();

   /**
    * Returns all <code>permission</code> elements
    * @return list of <code>permission</code> 
    */
   public List<FilePermissionType<FilePermissionsType<T>>> getAllPermission();

   /**
    * Removes all <code>permission</code> elements 
    * @return the current instance of <code>FilePermissionType<FilePermissionsType<T>></code> 
    */
   public FilePermissionsType<T> removeAllPermission();
}
