package org.jboss.shrinkwrap.descriptor.impl.jboss51; 

import org.jboss.shrinkwrap.descriptor.spi.node.Node;
import org.jboss.shrinkwrap.descriptor.api.jboss51.ClusterConfigType;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLDate;
import org.jboss.shrinkwrap.descriptor.impl.base.Strings;
import org.jboss.shrinkwrap.descriptor.api.DescriptorExporter;

/**
 * This class implements the <code> cluster-configType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public class ClusterConfigTypeImpl<T> implements Child<T>, ClusterConfigType<T>
{
   // -------------------------------------------------------------------------------------||
   // Instance Members 
   // -------------------------------------------------------------------------------------||

   private T t;
   private Node childNode;
   // -------------------------------------------------------------------------------------||
   // Constructor 
   // -------------------------------------------------------------------------------------||

   public ClusterConfigTypeImpl(T t, String nodeName, Node node)   {
      this.t = t;
      this.childNode = node.createChild(nodeName);
   }

   public ClusterConfigTypeImpl(T t, String nodeName, Node node, Node childNode)   {
      this.t = t;
      this.childNode = childNode;
   }


   public T up()
   {
      return t;
   }


 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ClusterConfigType ElementName: xsd:string ElementType : description
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Creates for all String objects representing <code>description</code> elements, 
    * a new <code>description</code> element 
    * @param values list of <code>description</code> objects 
    * @return the current instance of <code>ClusterConfigType<T></code> 
    */
   public ClusterConfigType<T> description(String ... values)
   {
      if (values != null)
      {
         for(String name: values)
         {
            childNode.createChild("description").text(name);
         }
      }
      return this;
   }

   /**
    * Returns all <code>description</code> elements
    * @return list of <code>description</code> 
    */
public List<String> getAllDescription()
   {
      List<String> result = new ArrayList<String>();
      List<Node> nodes = childNode.get("description");
      for (Node node : nodes)
      {
         result.add(node.getText());
      }
      return result;
   }

   /**
    * Removes the <code>description</code> element 
    * @return the current instance of <code>ClusterConfigType<T></code> 
    */
   public ClusterConfigType<T> removeAllDescription()
   {
      childNode.removeChildren("description");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ClusterConfigType ElementName: javaee:string ElementType : partition-name
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>partition-name</code> element
    * @param partitionName the value for the element <code>partition-name</code> 
    * @return the current instance of <code>ClusterConfigType<T></code> 
    */
   public ClusterConfigType<T> partitionName(String partitionName)
   {
      childNode.getOrCreate("partition-name").text(partitionName);
      return this;
   }

   /**
    * Returns the <code>partition-name</code> element
    * @return the node defined for the element <code>partition-name</code> 
    */
   public String getPartitionName()
   {
      return childNode.getTextValueForPatternName("partition-name");
   }

   /**
    * Removes the <code>partition-name</code> element 
    * @return the current instance of <code>ClusterConfigType<T></code> 
    */
   public ClusterConfigType<T> removePartitionName()
   {
      childNode.removeChildren("partition-name");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ClusterConfigType ElementName: javaee:string ElementType : home-load-balance-policy
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>home-load-balance-policy</code> element
    * @param homeLoadBalancePolicy the value for the element <code>home-load-balance-policy</code> 
    * @return the current instance of <code>ClusterConfigType<T></code> 
    */
   public ClusterConfigType<T> homeLoadBalancePolicy(String homeLoadBalancePolicy)
   {
      childNode.getOrCreate("home-load-balance-policy").text(homeLoadBalancePolicy);
      return this;
   }

   /**
    * Returns the <code>home-load-balance-policy</code> element
    * @return the node defined for the element <code>home-load-balance-policy</code> 
    */
   public String getHomeLoadBalancePolicy()
   {
      return childNode.getTextValueForPatternName("home-load-balance-policy");
   }

   /**
    * Removes the <code>home-load-balance-policy</code> element 
    * @return the current instance of <code>ClusterConfigType<T></code> 
    */
   public ClusterConfigType<T> removeHomeLoadBalancePolicy()
   {
      childNode.removeChildren("home-load-balance-policy");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ClusterConfigType ElementName: javaee:string ElementType : bean-load-balance-policy
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>bean-load-balance-policy</code> element
    * @param beanLoadBalancePolicy the value for the element <code>bean-load-balance-policy</code> 
    * @return the current instance of <code>ClusterConfigType<T></code> 
    */
   public ClusterConfigType<T> beanLoadBalancePolicy(String beanLoadBalancePolicy)
   {
      childNode.getOrCreate("bean-load-balance-policy").text(beanLoadBalancePolicy);
      return this;
   }

   /**
    * Returns the <code>bean-load-balance-policy</code> element
    * @return the node defined for the element <code>bean-load-balance-policy</code> 
    */
   public String getBeanLoadBalancePolicy()
   {
      return childNode.getTextValueForPatternName("bean-load-balance-policy");
   }

   /**
    * Removes the <code>bean-load-balance-policy</code> element 
    * @return the current instance of <code>ClusterConfigType<T></code> 
    */
   public ClusterConfigType<T> removeBeanLoadBalancePolicy()
   {
      childNode.removeChildren("bean-load-balance-policy");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ClusterConfigType ElementName: javaee:string ElementType : load-balance-policy
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>load-balance-policy</code> element
    * @param loadBalancePolicy the value for the element <code>load-balance-policy</code> 
    * @return the current instance of <code>ClusterConfigType<T></code> 
    */
   public ClusterConfigType<T> loadBalancePolicy(String loadBalancePolicy)
   {
      childNode.getOrCreate("load-balance-policy").text(loadBalancePolicy);
      return this;
   }

   /**
    * Returns the <code>load-balance-policy</code> element
    * @return the node defined for the element <code>load-balance-policy</code> 
    */
   public String getLoadBalancePolicy()
   {
      return childNode.getTextValueForPatternName("load-balance-policy");
   }

   /**
    * Removes the <code>load-balance-policy</code> element 
    * @return the current instance of <code>ClusterConfigType<T></code> 
    */
   public ClusterConfigType<T> removeLoadBalancePolicy()
   {
      childNode.removeChildren("load-balance-policy");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ClusterConfigType ElementName: xsd:token ElementType : session-state-manager-jndi-name
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>session-state-manager-jndi-name</code> element
    * @param sessionStateManagerJndiName the value for the element <code>session-state-manager-jndi-name</code> 
    * @return the current instance of <code>ClusterConfigType<T></code> 
    */
   public ClusterConfigType<T> sessionStateManagerJndiName(String sessionStateManagerJndiName)
   {
      childNode.getOrCreate("session-state-manager-jndi-name").text(sessionStateManagerJndiName);
      return this;
   }

   /**
    * Returns the <code>session-state-manager-jndi-name</code> element
    * @return the node defined for the element <code>session-state-manager-jndi-name</code> 
    */
   public String getSessionStateManagerJndiName()
   {
      return childNode.getTextValueForPatternName("session-state-manager-jndi-name");
   }

   /**
    * Removes the <code>session-state-manager-jndi-name</code> element 
    * @return the current instance of <code>ClusterConfigType<T></code> 
    */
   public ClusterConfigType<T> removeSessionStateManagerJndiName()
   {
      childNode.removeChildren("session-state-manager-jndi-name");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ClusterConfigType ElementName: xsd:ID ElementType : id
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>id</code> attribute
    * @param id the value for the attribute <code>id</code> 
    * @return the current instance of <code>ClusterConfigType<T></code> 
    */
   public ClusterConfigType<T> id(String id)
   {
      childNode.attribute("id", id);
      return this;
   }

   /**
    * Returns the <code>id</code> attribute
    * @return the value defined for the attribute <code>id</code> 
    */
      public String getId()
   {
      return childNode.getAttribute("id");
   }

   /**
    * Removes the <code>id</code> attribute 
    * @return the current instance of <code>ClusterConfigType<T></code> 
    */
   public ClusterConfigType<T> removeId()
   {
      childNode.removeAttribute("id");
      return this;
   }
}
