package org.jboss.shrinkwrap.descriptor.impl.jboss51; 

import org.jboss.shrinkwrap.descriptor.spi.node.Node;
import org.jboss.shrinkwrap.descriptor.api.jboss51.EnterpriseBeansType;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLDate;
import org.jboss.shrinkwrap.descriptor.impl.base.Strings;
import org.jboss.shrinkwrap.descriptor.api.DescriptorExporter;
import org.jboss.shrinkwrap.descriptor.api.jboss51.SessionBeanType;
import org.jboss.shrinkwrap.descriptor.impl.jboss51.SessionBeanTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jboss51.MessageDrivenBeanType;
import org.jboss.shrinkwrap.descriptor.impl.jboss51.MessageDrivenBeanTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jboss51.ServiceBeanType;
import org.jboss.shrinkwrap.descriptor.impl.jboss51.ServiceBeanTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jboss51.ConsumerBeanType;
import org.jboss.shrinkwrap.descriptor.impl.jboss51.ConsumerBeanTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jboss51.GenericBeanType;
import org.jboss.shrinkwrap.descriptor.impl.jboss51.GenericBeanTypeImpl;

/**
 * This class implements the <code> enterprise-beansType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public class EnterpriseBeansTypeImpl<T> implements Child<T>, EnterpriseBeansType<T>
{
   // -------------------------------------------------------------------------------------||
   // Instance Members 
   // -------------------------------------------------------------------------------------||

   private T t;
   private Node childNode;
   // -------------------------------------------------------------------------------------||
   // Constructor 
   // -------------------------------------------------------------------------------------||

   public EnterpriseBeansTypeImpl(T t, String nodeName, Node node)   {
      this.t = t;
      this.childNode = node.createChild(nodeName);
   }

   public EnterpriseBeansTypeImpl(T t, String nodeName, Node node, Node childNode)   {
      this.t = t;
      this.childNode = childNode;
   }


   public T up()
   {
      return t;
   }


 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: EnterpriseBeansType ElementName: jboss:session-beanType ElementType : session
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>session</code> element will be created and returned.
    * Otherwise, the first existing <code>session</code> element will be returned.
    * @return the instance defined for the element <code>session</code> 
    */
   public SessionBeanType<EnterpriseBeansType<T>> getOrCreateSession()
   {
      List<Node> nodeList = childNode.get("session");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new SessionBeanTypeImpl<EnterpriseBeansType<T>>(this, "session", childNode, nodeList.get(0));
      }
      return createSession();
   }

   /**
    * Creates a new <code>session</code> element 
    * @return the new created instance of <code>SessionBeanType<EnterpriseBeansType<T>></code> 
    */
   public SessionBeanType<EnterpriseBeansType<T>> createSession()
   {
      return new SessionBeanTypeImpl<EnterpriseBeansType<T>>(this, "session", childNode);
   }

   /**
    * Returns all <code>session</code> elements
    * @return list of <code>session</code> 
    */
   public List<SessionBeanType<EnterpriseBeansType<T>>> getAllSession()
   {
      List<SessionBeanType<EnterpriseBeansType<T>>> list = new ArrayList<SessionBeanType<EnterpriseBeansType<T>>>();
      List<Node> nodeList = childNode.get("session");
      for(Node node: nodeList)
      {
         SessionBeanType<EnterpriseBeansType<T>>  type = new SessionBeanTypeImpl<EnterpriseBeansType<T>>(this, "session", childNode, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>session</code> elements 
    * @return the current instance of <code>SessionBeanType<EnterpriseBeansType<T>></code> 
    */
   public EnterpriseBeansType<T> removeAllSession()
   {
      childNode.removeChildren("session");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: EnterpriseBeansType ElementName: jboss:message-driven-beanType ElementType : message-driven
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>message-driven</code> element will be created and returned.
    * Otherwise, the first existing <code>message-driven</code> element will be returned.
    * @return the instance defined for the element <code>message-driven</code> 
    */
   public MessageDrivenBeanType<EnterpriseBeansType<T>> getOrCreateMessageDriven()
   {
      List<Node> nodeList = childNode.get("message-driven");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new MessageDrivenBeanTypeImpl<EnterpriseBeansType<T>>(this, "message-driven", childNode, nodeList.get(0));
      }
      return createMessageDriven();
   }

   /**
    * Creates a new <code>message-driven</code> element 
    * @return the new created instance of <code>MessageDrivenBeanType<EnterpriseBeansType<T>></code> 
    */
   public MessageDrivenBeanType<EnterpriseBeansType<T>> createMessageDriven()
   {
      return new MessageDrivenBeanTypeImpl<EnterpriseBeansType<T>>(this, "message-driven", childNode);
   }

   /**
    * Returns all <code>message-driven</code> elements
    * @return list of <code>message-driven</code> 
    */
   public List<MessageDrivenBeanType<EnterpriseBeansType<T>>> getAllMessageDriven()
   {
      List<MessageDrivenBeanType<EnterpriseBeansType<T>>> list = new ArrayList<MessageDrivenBeanType<EnterpriseBeansType<T>>>();
      List<Node> nodeList = childNode.get("message-driven");
      for(Node node: nodeList)
      {
         MessageDrivenBeanType<EnterpriseBeansType<T>>  type = new MessageDrivenBeanTypeImpl<EnterpriseBeansType<T>>(this, "message-driven", childNode, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>message-driven</code> elements 
    * @return the current instance of <code>MessageDrivenBeanType<EnterpriseBeansType<T>></code> 
    */
   public EnterpriseBeansType<T> removeAllMessageDriven()
   {
      childNode.removeChildren("message-driven");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: EnterpriseBeansType ElementName: jboss:service-beanType ElementType : service
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>service</code> element will be created and returned.
    * Otherwise, the first existing <code>service</code> element will be returned.
    * @return the instance defined for the element <code>service</code> 
    */
   public ServiceBeanType<EnterpriseBeansType<T>> getOrCreateService()
   {
      List<Node> nodeList = childNode.get("service");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new ServiceBeanTypeImpl<EnterpriseBeansType<T>>(this, "service", childNode, nodeList.get(0));
      }
      return createService();
   }

   /**
    * Creates a new <code>service</code> element 
    * @return the new created instance of <code>ServiceBeanType<EnterpriseBeansType<T>></code> 
    */
   public ServiceBeanType<EnterpriseBeansType<T>> createService()
   {
      return new ServiceBeanTypeImpl<EnterpriseBeansType<T>>(this, "service", childNode);
   }

   /**
    * Returns all <code>service</code> elements
    * @return list of <code>service</code> 
    */
   public List<ServiceBeanType<EnterpriseBeansType<T>>> getAllService()
   {
      List<ServiceBeanType<EnterpriseBeansType<T>>> list = new ArrayList<ServiceBeanType<EnterpriseBeansType<T>>>();
      List<Node> nodeList = childNode.get("service");
      for(Node node: nodeList)
      {
         ServiceBeanType<EnterpriseBeansType<T>>  type = new ServiceBeanTypeImpl<EnterpriseBeansType<T>>(this, "service", childNode, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>service</code> elements 
    * @return the current instance of <code>ServiceBeanType<EnterpriseBeansType<T>></code> 
    */
   public EnterpriseBeansType<T> removeAllService()
   {
      childNode.removeChildren("service");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: EnterpriseBeansType ElementName: jboss:consumer-beanType ElementType : consumer
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>consumer</code> element will be created and returned.
    * Otherwise, the first existing <code>consumer</code> element will be returned.
    * @return the instance defined for the element <code>consumer</code> 
    */
   public ConsumerBeanType<EnterpriseBeansType<T>> getOrCreateConsumer()
   {
      List<Node> nodeList = childNode.get("consumer");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new ConsumerBeanTypeImpl<EnterpriseBeansType<T>>(this, "consumer", childNode, nodeList.get(0));
      }
      return createConsumer();
   }

   /**
    * Creates a new <code>consumer</code> element 
    * @return the new created instance of <code>ConsumerBeanType<EnterpriseBeansType<T>></code> 
    */
   public ConsumerBeanType<EnterpriseBeansType<T>> createConsumer()
   {
      return new ConsumerBeanTypeImpl<EnterpriseBeansType<T>>(this, "consumer", childNode);
   }

   /**
    * Returns all <code>consumer</code> elements
    * @return list of <code>consumer</code> 
    */
   public List<ConsumerBeanType<EnterpriseBeansType<T>>> getAllConsumer()
   {
      List<ConsumerBeanType<EnterpriseBeansType<T>>> list = new ArrayList<ConsumerBeanType<EnterpriseBeansType<T>>>();
      List<Node> nodeList = childNode.get("consumer");
      for(Node node: nodeList)
      {
         ConsumerBeanType<EnterpriseBeansType<T>>  type = new ConsumerBeanTypeImpl<EnterpriseBeansType<T>>(this, "consumer", childNode, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>consumer</code> elements 
    * @return the current instance of <code>ConsumerBeanType<EnterpriseBeansType<T>></code> 
    */
   public EnterpriseBeansType<T> removeAllConsumer()
   {
      childNode.removeChildren("consumer");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: EnterpriseBeansType ElementName: jboss:generic-beanType ElementType : ejb
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>ejb</code> element will be created and returned.
    * Otherwise, the first existing <code>ejb</code> element will be returned.
    * @return the instance defined for the element <code>ejb</code> 
    */
   public GenericBeanType<EnterpriseBeansType<T>> getOrCreateEjb()
   {
      List<Node> nodeList = childNode.get("ejb");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new GenericBeanTypeImpl<EnterpriseBeansType<T>>(this, "ejb", childNode, nodeList.get(0));
      }
      return createEjb();
   }

   /**
    * Creates a new <code>ejb</code> element 
    * @return the new created instance of <code>GenericBeanType<EnterpriseBeansType<T>></code> 
    */
   public GenericBeanType<EnterpriseBeansType<T>> createEjb()
   {
      return new GenericBeanTypeImpl<EnterpriseBeansType<T>>(this, "ejb", childNode);
   }

   /**
    * Returns all <code>ejb</code> elements
    * @return list of <code>ejb</code> 
    */
   public List<GenericBeanType<EnterpriseBeansType<T>>> getAllEjb()
   {
      List<GenericBeanType<EnterpriseBeansType<T>>> list = new ArrayList<GenericBeanType<EnterpriseBeansType<T>>>();
      List<Node> nodeList = childNode.get("ejb");
      for(Node node: nodeList)
      {
         GenericBeanType<EnterpriseBeansType<T>>  type = new GenericBeanTypeImpl<EnterpriseBeansType<T>>(this, "ejb", childNode, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>ejb</code> elements 
    * @return the current instance of <code>GenericBeanType<EnterpriseBeansType<T>></code> 
    */
   public EnterpriseBeansType<T> removeAllEjb()
   {
      childNode.removeChildren("ejb");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: EnterpriseBeansType ElementName: xsd:ID ElementType : id
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>id</code> attribute
    * @param id the value for the attribute <code>id</code> 
    * @return the current instance of <code>EnterpriseBeansType<T></code> 
    */
   public EnterpriseBeansType<T> id(String id)
   {
      childNode.attribute("id", id);
      return this;
   }

   /**
    * Returns the <code>id</code> attribute
    * @return the value defined for the attribute <code>id</code> 
    */
      public String getId()
   {
      return childNode.getAttribute("id");
   }

   /**
    * Removes the <code>id</code> attribute 
    * @return the current instance of <code>EnterpriseBeansType<T></code> 
    */
   public EnterpriseBeansType<T> removeId()
   {
      childNode.removeAttribute("id");
      return this;
   }
}
