package org.jboss.shrinkwrap.descriptor.impl.jbossdeployment12; 

import org.jboss.shrinkwrap.descriptor.spi.node.Node;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment12.TransformerSetType;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLDate;
import org.jboss.shrinkwrap.descriptor.impl.base.Strings;
import org.jboss.shrinkwrap.descriptor.api.DescriptorExporter;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment12.TransformerType;
import org.jboss.shrinkwrap.descriptor.impl.jbossdeployment12.TransformerTypeImpl;

/**
 * This class implements the <code> transformerSetType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public class TransformerSetTypeImpl<T> implements Child<T>, TransformerSetType<T>
{
   // -------------------------------------------------------------------------------------||
   // Instance Members 
   // -------------------------------------------------------------------------------------||

   private T t;
   private Node childNode;
   // -------------------------------------------------------------------------------------||
   // Constructor 
   // -------------------------------------------------------------------------------------||

   public TransformerSetTypeImpl(T t, String nodeName, Node node)   {
      this.t = t;
      this.childNode = node.createChild(nodeName);
   }

   public TransformerSetTypeImpl(T t, String nodeName, Node node, Node childNode)   {
      this.t = t;
      this.childNode = childNode;
   }


   public T up()
   {
      return t;
   }


 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: TransformerSetType ElementName: jboss:transformerType ElementType : transformer
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>transformer</code> element will be created and returned.
    * Otherwise, the first existing <code>transformer</code> element will be returned.
    * @return the instance defined for the element <code>transformer</code> 
    */
   public TransformerType<TransformerSetType<T>> getOrCreateTransformer()
   {
      List<Node> nodeList = childNode.get("transformer");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new TransformerTypeImpl<TransformerSetType<T>>(this, "transformer", childNode, nodeList.get(0));
      }
      return createTransformer();
   }

   /**
    * Creates a new <code>transformer</code> element 
    * @return the new created instance of <code>TransformerType<TransformerSetType<T>></code> 
    */
   public TransformerType<TransformerSetType<T>> createTransformer()
   {
      return new TransformerTypeImpl<TransformerSetType<T>>(this, "transformer", childNode);
   }

   /**
    * Returns all <code>transformer</code> elements
    * @return list of <code>transformer</code> 
    */
   public List<TransformerType<TransformerSetType<T>>> getAllTransformer()
   {
      List<TransformerType<TransformerSetType<T>>> list = new ArrayList<TransformerType<TransformerSetType<T>>>();
      List<Node> nodeList = childNode.get("transformer");
      for(Node node: nodeList)
      {
         TransformerType<TransformerSetType<T>>  type = new TransformerTypeImpl<TransformerSetType<T>>(this, "transformer", childNode, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>transformer</code> elements 
    * @return the current instance of <code>TransformerType<TransformerSetType<T>></code> 
    */
   public TransformerSetType<T> removeAllTransformer()
   {
      childNode.removeChildren("transformer");
      return this;
   }
}
