package org.wildfly.swarm.config.keycloak;

import org.wildfly.swarm.config.keycloak.Realm;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface RealmConsumer<T extends Realm<T>> {

	/**
	 * Configure a pre-constructed instance of Realm resource
	 * 
	 * @parameter Instance of Realm to configure
	 * @return nothing
	 */
	void accept(T value);

	default RealmConsumer<T> andThen(RealmConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}