package org.jboss.shrinkwrap.descriptor.api.orm21; 

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.api.orm.*;
import org.jboss.shrinkwrap.descriptor.api.orm.OrmColumnResultCommType;
/**
 * This interface defines the contract for the <code> column-result </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public interface ColumnResult<T> extends Child<T>, 
    OrmColumnResultCommType<T, ColumnResult<T>> { 

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ColumnResult ElementName: xsd:string ElementType : name
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>name</code> attribute
    * @param name the value for the attribute <code>name</code> 
    * @return the current instance of <code>ColumnResult<T></code> 
    */
   public ColumnResult<T> name(String name);

   /**
    * Returns the <code>name</code> attribute
    * @return the value defined for the attribute <code>name</code> 
    */
   public String getName();

   /**
    * Removes the <code>name</code> attribute 
    * @return the current instance of <code>ColumnResult<T></code> 
    */
   public ColumnResult<T> removeName();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ColumnResult ElementName: xsd:string ElementType : class
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>class</code> attribute
    * @param clazz the value for the attribute <code>class</code> 
    * @return the current instance of <code>ColumnResult<T></code> 
    */
   public ColumnResult<T> clazz(String clazz);

   /**
    * Returns the <code>class</code> attribute
    * @return the value defined for the attribute <code>class</code> 
    */
   public String getClazz();

   /**
    * Removes the <code>class</code> attribute 
    * @return the current instance of <code>ColumnResult<T></code> 
    */
   public ColumnResult<T> removeClazzAttr();
}
