/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hystrix.processor;

import com.netflix.hystrix.HystrixCommand;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.hystrix.processor.HystrixProcessorCommandFallbackViaNetwork;
import org.apache.camel.util.ExchangeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HystrixProcessorCommand
extends HystrixCommand {
    private static final Logger LOG = LoggerFactory.getLogger(HystrixProcessorCommand.class);
    private final Exchange exchange;
    private final Processor processor;
    private final Processor fallback;
    private final HystrixProcessorCommandFallbackViaNetwork fallbackCommand;
    private final AtomicBoolean fallbackInUse = new AtomicBoolean();
    private final Object lock = new Object();

    public HystrixProcessorCommand(HystrixCommand.Setter setter, Exchange exchange, Processor processor, Processor fallback, HystrixProcessorCommandFallbackViaNetwork fallbackCommand) {
        super(setter);
        this.exchange = exchange;
        this.processor = processor;
        this.fallback = fallback;
        this.fallbackCommand = fallbackCommand;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Message getFallback() {
        Object object = this.lock;
        synchronized (object) {
            this.fallbackInUse.set(true);
        }
        if (this.fallback == null && this.fallbackCommand == null) {
            throw new UnsupportedOperationException("No fallback available.");
        }
        Throwable exception = this.getExecutionException();
        if (exception != null) {
            LOG.debug("Error occurred processing. Will now run fallback. Exception class: {} message: {}.", (Object)exception.getClass().getName(), (Object)exception.getMessage());
        } else {
            LOG.debug("Error occurred processing. Will now run fallback.");
        }
        if (this.exchange.getProperty("CamelFailureEndpoint") == null) {
            this.exchange.setProperty("CamelFailureEndpoint", this.exchange.getProperty("CamelToEndpoint"));
        }
        this.exchange.setProperty("CamelExceptionHandled", (Object)true);
        this.exchange.setProperty("CamelExceptionCaught", (Object)exception);
        this.exchange.removeProperty("CamelRouteStop");
        this.exchange.setException(null);
        this.exchange.removeProperty("CamelRedeliveryExhausted");
        try {
            if (this.fallbackCommand != null) {
                return (Message)this.fallbackCommand.execute();
            }
            LOG.debug("Running fallback: {} with exchange: {}", (Object)this.fallback, (Object)this.exchange);
            this.fallback.process(this.exchange);
            LOG.debug("Running fallback: {} with exchange: {} done", (Object)this.fallback, (Object)this.exchange);
        }
        catch (Exception e) {
            this.exchange.setException((Throwable)e);
        }
        return this.exchange.hasOut() ? this.exchange.getOut() : this.exchange.getIn();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Message run() throws Exception {
        LOG.debug("Running processor: {} with exchange: {}", (Object)this.processor, (Object)this.exchange);
        Exchange copy = ExchangeHelper.createCorrelatedCopy((Exchange)this.exchange, (boolean)false, (boolean)false);
        try {
            this.processor.process(copy);
        }
        catch (Exception e) {
            copy.setException((Throwable)e);
        }
        if (this.fallbackInUse.get()) {
            LOG.debug("Exiting run command as fallback is already in use processing exchange: {}", (Object)this.exchange);
            return null;
        }
        Throwable cause = this.getExecutionException();
        Object object = this.lock;
        synchronized (object) {
            if (this.fallbackInUse.get()) {
                LOG.debug("Exiting run command as fallback is already in use processing exchange: {}", (Object)this.exchange);
                return null;
            }
            ExchangeHelper.copyResults((Exchange)this.exchange, (Exchange)copy);
            Boolean fallbackEnabled = (Boolean)this.getProperties().fallbackEnabled().get();
            if (cause != null) {
                this.exchange.setException((Throwable)new CamelExchangeException("Hystrix execution exception occurred while processing Exchange", this.exchange, cause));
            }
            if ((this.fallback != null || this.fallbackCommand != null) && (fallbackEnabled == null || fallbackEnabled.booleanValue() && this.exchange.getException() != null)) {
                throw this.exchange.getException();
            }
            LOG.debug("Running processor: {} with exchange: {} done", (Object)this.processor, (Object)this.exchange);
            return this.exchange.hasOut() ? this.exchange.getOut() : this.exchange.getIn();
        }
    }
}

