/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.impls.tg;

import com.tinkerpop.blueprints.CloseableIterable;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Index;
import com.tinkerpop.blueprints.util.StringFactory;
import com.tinkerpop.blueprints.util.WrappingCloseableIterable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class TinkerIndex<T extends Element>
implements Index<T>,
Serializable {
    protected Map<String, Map<Object, Set<T>>> index = new HashMap<String, Map<Object, Set<T>>>();
    protected final String indexName;
    protected final Class<T> indexClass;

    public TinkerIndex(String indexName, Class<T> indexClass) {
        this.indexName = indexName;
        this.indexClass = indexClass;
    }

    @Override
    public String getIndexName() {
        return this.indexName;
    }

    @Override
    public Class<T> getIndexClass() {
        return this.indexClass;
    }

    @Override
    public void put(String key, Object value, T element) {
        Set<T> objects;
        Map<Object, Set<T>> keyMap = this.index.get(key);
        if (keyMap == null) {
            keyMap = new HashMap<Object, Set<T>>();
            this.index.put(key, keyMap);
        }
        if (null == (objects = keyMap.get(value))) {
            objects = new HashSet<T>();
            keyMap.put(value, objects);
        }
        objects.add(element);
    }

    @Override
    public CloseableIterable<T> get(String key, Object value) {
        Map<Object, Set<T>> keyMap = this.index.get(key);
        if (null == keyMap) {
            return new WrappingCloseableIterable(Collections.emptyList());
        }
        Set<T> set = keyMap.get(value);
        if (null == set) {
            return new WrappingCloseableIterable(Collections.emptyList());
        }
        return new WrappingCloseableIterable<T>(new ArrayList<T>(set));
    }

    @Override
    public CloseableIterable<T> query(String key, Object query) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long count(String key, Object value) {
        Map<Object, Set<T>> keyMap = this.index.get(key);
        if (null == keyMap) {
            return 0L;
        }
        Set<T> set = keyMap.get(value);
        if (null == set) {
            return 0L;
        }
        return set.size();
    }

    @Override
    public void remove(String key, Object value, T element) {
        Set<T> objects;
        Map<Object, Set<T>> keyMap = this.index.get(key);
        if (null != keyMap && null != (objects = keyMap.get(value))) {
            objects.remove(element);
            if (objects.size() == 0) {
                keyMap.remove(value);
            }
        }
    }

    public void removeElement(T element) {
        if (this.indexClass.isAssignableFrom(element.getClass())) {
            for (Map<Object, Set<T>> map : this.index.values()) {
                for (Set<T> set : map.values()) {
                    set.remove(element);
                }
            }
        }
    }

    public String toString() {
        return StringFactory.indexString(this);
    }
}

