/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jcache.processor.idempotent;

import javax.cache.Cache;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedOperation;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.component.jcache.JCacheConfiguration;
import org.apache.camel.component.jcache.JCacheHelper;
import org.apache.camel.component.jcache.JCacheManager;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.ObjectHelper;

@ManagedResource(description="JCache based message id repository")
public class JCacheIdempotentRepository
extends ServiceSupport
implements IdempotentRepository<Object> {
    private JCacheConfiguration configuration = new JCacheConfiguration();
    private Cache<Object, Boolean> cache;
    private JCacheManager<Object, Boolean> cacheManager;

    public JCacheConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(JCacheConfiguration configuration) {
        this.configuration = configuration;
    }

    public Cache<Object, Boolean> getCache() {
        return this.cache;
    }

    public void setCache(Cache<Object, Boolean> cache) {
        this.cache = cache;
    }

    @ManagedOperation(description="Adds the key to the store")
    public boolean add(Object key) {
        return this.cache.putIfAbsent(key, (Object)true);
    }

    @ManagedOperation(description="Does the store contain the given key")
    public boolean contains(Object key) {
        return this.cache.containsKey(key);
    }

    @ManagedOperation(description="Remove the key from the store")
    public boolean remove(Object key) {
        return this.cache.remove(key);
    }

    @ManagedOperation(description="Clear the store")
    public void clear() {
        this.cache.clear();
    }

    public void setCacheName(String cacheName) {
        this.configuration.setCacheName(cacheName);
    }

    @ManagedAttribute(description="The processor name")
    public String getCacheName() {
        return this.configuration.getCacheName();
    }

    public boolean confirm(Object key) {
        return this.cache.replace(key, (Object)false, (Object)true);
    }

    protected void doStart() throws Exception {
        if (this.cache != null) {
            this.cacheManager = new JCacheManager<Object, Boolean>(this.cache);
        } else {
            this.cacheManager = JCacheHelper.createManager((JCacheConfiguration)ObjectHelper.notNull((Object)this.configuration, (String)"configuration"));
            this.cache = this.cacheManager.getCache();
        }
    }

    protected void doStop() throws Exception {
        this.cacheManager.close();
    }
}

