/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient.model;

import com.openshift.internal.restclient.capability.CapabilityInitializer;
import com.openshift.internal.restclient.model.KubernetesResource;
import com.openshift.internal.restclient.model.ServicePort;
import com.openshift.restclient.IClient;
import com.openshift.restclient.model.IPod;
import com.openshift.restclient.model.IService;
import com.openshift.restclient.model.IServicePort;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jboss.dmr.ModelNode;

public class Service
extends KubernetesResource
implements IService {
    private static final String SERVICE_SELECTOR = "spec.selector";
    private static final String SERVICE_PORT = "spec.ports";

    public Service(ModelNode node, IClient client, Map<String, String[]> propertyKeys) {
        super(node, client, propertyKeys);
        CapabilityInitializer.initializeCapabilities(this.getModifiableCapabilities(), this, this.getClient());
    }

    @Override
    public void setPort(int port) {
        IServicePort lowestPort = this.getLowestPort();
        if (lowestPort == null) {
            lowestPort = this.addPort(0, 0);
        }
        lowestPort.setPort(port);
    }

    @Override
    public IServicePort addPort(int port, int targetPort) {
        return this.addPort(port, targetPort, null);
    }

    @Override
    public IServicePort addPort(int port, int targetPort, String name) {
        ServicePort servicePort = new ServicePort(this.get(SERVICE_PORT).add());
        if (port > 0) {
            servicePort.setPort(port);
        }
        if (targetPort > 0) {
            servicePort.setTargetPort(targetPort);
        }
        if (StringUtils.isNotEmpty((String)name)) {
            servicePort.setName(name);
        }
        return servicePort;
    }

    @Override
    public int getPort() {
        IServicePort port = this.getLowestPort();
        return port != null ? port.getPort() : 0;
    }

    private IServicePort getLowestPort() {
        List<IServicePort> ports = this.getPorts();
        return ports.size() == 0 ? null : ports.get(0);
    }

    @Override
    public List<IServicePort> getPorts() {
        return this.getPorts(false);
    }

    private List<IServicePort> getPorts(boolean modifiable) {
        ArrayList<IServicePort> ports = new ArrayList<IServicePort>();
        if (!this.get(SERVICE_PORT).isDefined()) {
            return ports;
        }
        for (ModelNode node : this.get(SERVICE_PORT).asList()) {
            ports.add(new ServicePort(node));
        }
        Collections.sort(ports, new Comparator<IServicePort>(){

            @Override
            public int compare(IServicePort first, IServicePort second) {
                Integer port0 = first.getPort();
                Integer port1 = second.getPort();
                return port0.compareTo(port1);
            }
        });
        return modifiable ? ports : Collections.unmodifiableList(ports);
    }

    @Override
    public void setPorts(List<IServicePort> ports) {
        ModelNode portspec = this.get(SERVICE_PORT).clear();
        for (IServicePort port : ports) {
            new ServicePort(portspec.add(), port);
        }
    }

    @Override
    public Map<String, String> getSelector() {
        return this.asMap(SERVICE_SELECTOR);
    }

    @Override
    public void setSelector(Map<String, String> selector) {
        ModelNode node = new ModelNode();
        for (Map.Entry<String, String> entry : selector.entrySet()) {
            node.get(entry.getKey()).set(entry.getValue());
        }
        this.get(SERVICE_SELECTOR).set(node);
    }

    @Override
    public void setSelector(String key, String value) {
        this.get(SERVICE_SELECTOR).get(key).set(value);
    }

    @Override
    public void setTargetPort(int port) {
        IServicePort portspec = this.getLowestPort();
        if (portspec == null) {
            portspec = this.addPort(0, 0);
        }
        portspec.setTargetPort(port);
    }

    @Override
    public String getTargetPort() {
        IServicePort port = this.getLowestPort();
        return port != null ? port.getTargetPort() : "0";
    }

    @Override
    @Deprecated
    public String getPortalIP() {
        String tmp = this.asString("spec.portalIP");
        if (StringUtils.isBlank((String)tmp)) {
            tmp = this.getClusterIP();
        }
        return tmp;
    }

    @Override
    public String getClusterIP() {
        return this.asString("spec.clusterIP");
    }

    @Override
    public List<IPod> getPods() {
        if (this.getClient() == null) {
            return new ArrayList<IPod>();
        }
        return this.getClient().list("Pod", this.getNamespace(), this.getSelector());
    }

    @Override
    public String getType() {
        return this.asString("spec.type");
    }

    @Override
    public void setType(String type) {
        this.set("spec.type", type);
    }
}

