/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.interceptors;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.deployers.StartupCountdown;
import org.jboss.as.ee.component.interceptors.InvocationType;
import org.jboss.as.ejb3.component.interceptors.AsyncInvocationTask;
import org.jboss.as.ejb3.component.interceptors.CancellationFlag;
import org.jboss.as.ejb3.component.session.SessionBeanComponent;
import org.jboss.as.security.remoting.RemotingContext;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InterceptorFactoryContext;
import org.jboss.remoting3.Connection;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;
import org.jboss.security.plugins.JBossSecurityContext;
import org.wildfly.security.manager.WildFlySecurityManager;

public final class AsyncFutureInterceptorFactory
implements InterceptorFactory {
    public static final InterceptorFactory INSTANCE = new AsyncFutureInterceptorFactory();

    private AsyncFutureInterceptorFactory() {
    }

    public Interceptor create(InterceptorFactoryContext context) {
        final SessionBeanComponent component = (SessionBeanComponent)((Object)context.getContextData().get(Component.class));
        return new Interceptor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object processInvocation(InterceptorContext context) throws Exception {
                final InterceptorContext asyncInterceptorContext = context.clone();
                asyncInterceptorContext.putPrivateData(InvocationType.class, (Object)InvocationType.ASYNC);
                CancellationFlag flag = new CancellationFlag();
                SecurityContext securityContext = WildFlySecurityManager.isChecking() ? AccessController.doPrivileged(new PrivilegedAction<SecurityContext>(){

                    @Override
                    public SecurityContext run() {
                        return SecurityContextAssociation.getSecurityContext();
                    }
                }) : SecurityContextAssociation.getSecurityContext();
                final SecurityContext clonedSecurityContext = securityContext instanceof JBossSecurityContext ? (SecurityContext)((JBossSecurityContext)securityContext).clone() : securityContext;
                final Connection remoteConnection = AsyncFutureInterceptorFactory.this.getConnection();
                final StartupCountdown.Frame frame = StartupCountdown.current();
                AsyncInvocationTask task = new AsyncInvocationTask(flag){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    protected Object runInvocation() throws Exception {
                        AsyncFutureInterceptorFactory.setSecurityContextOnAssociation(clonedSecurityContext);
                        AsyncFutureInterceptorFactory.this.setConnection(remoteConnection);
                        StartupCountdown.restore((StartupCountdown.Frame)frame);
                        try {
                            Object object = asyncInterceptorContext.proceed();
                            return object;
                        }
                        finally {
                            StartupCountdown.restore(null);
                            try {
                                AsyncFutureInterceptorFactory.clearSecurityContextOnAssociation();
                            }
                            finally {
                                AsyncFutureInterceptorFactory.this.clearConnection();
                            }
                        }
                    }
                };
                asyncInterceptorContext.putPrivateData(CancellationFlag.class, (Object)flag);
                ClassLoader oldClassLoader = WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)null);
                try {
                    component.getAsynchronousExecutor().execute(task);
                }
                finally {
                    WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)oldClassLoader);
                }
                return task;
            }
        };
    }

    private void setConnection(final Connection remoteConnection) {
        if (WildFlySecurityManager.isChecking()) {
            WildFlySecurityManager.doUnchecked((PrivilegedAction)new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    RemotingContext.setConnection((Connection)remoteConnection);
                    return null;
                }
            });
        } else {
            RemotingContext.setConnection((Connection)remoteConnection);
        }
    }

    private void clearConnection() {
        if (WildFlySecurityManager.isChecking()) {
            WildFlySecurityManager.doUnchecked((PrivilegedAction)new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    RemotingContext.clear();
                    return null;
                }
            });
        } else {
            RemotingContext.clear();
        }
    }

    private Connection getConnection() {
        if (WildFlySecurityManager.isChecking()) {
            return (Connection)WildFlySecurityManager.doUnchecked((PrivilegedAction)new PrivilegedAction<Connection>(){

                @Override
                public Connection run() {
                    return RemotingContext.getConnection();
                }
            });
        }
        return RemotingContext.getConnection();
    }

    private static void setSecurityContextOnAssociation(final SecurityContext sc) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                SecurityContextAssociation.setSecurityContext((SecurityContext)sc);
                return null;
            }
        });
    }

    private static void clearSecurityContextOnAssociation() {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                SecurityContextAssociation.clearSecurityContext();
                return null;
            }
        });
    }
}

